/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.net.ServerData;

public class SavedServerList {
    private File serverListFile;
    public List<ServerData> servers = new ArrayList<ServerData>();

    private SavedServerList() {
    }

    public static SavedServerList readFromFile(File file) {
        SavedServerList serverList = new SavedServerList();
        serverList.serverListFile = file;
        try {
            InputStream fileStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            DataInputStream dataStream = new DataInputStream(fileStream);
            CompoundTag tag = new CompoundTag();
            tag.read(dataStream);
            for (Tag<?> subTag : tag.getValues()) {
                if (!(subTag instanceof CompoundTag)) continue;
                serverList.servers.add(ServerData.readFromTag((CompoundTag)subTag));
            }
            fileStream.close();
            dataStream.close();
        }
        catch (Exception e) {
            return serverList;
        }
        return serverList;
    }

    public void writeToFile() {
        try {
            OutputStream fileStream = Files.newOutputStream(this.serverListFile.toPath(), new OpenOption[0]);
            DataOutputStream dataStream = new DataOutputStream(fileStream);
            CompoundTag tag = new CompoundTag();
            for (int i = 0; i < this.servers.size(); ++i) {
                this.servers.get(i).writeToTag(tag, i);
            }
            tag.write(dataStream);
            fileStream.close();
            dataStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

