/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.net.command.helpers.EntitySelectorParser;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.net.command.util.ConcatIterable;

public class EntityArgumentType
implements ArgumentType<EntitySelector> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "entity.11203");
    private final boolean singleEntity;
    private final boolean playerOnly;

    private EntityArgumentType(boolean singleEntity, boolean playerOnly) {
        this.singleEntity = singleEntity;
        this.playerOnly = playerOnly;
    }

    public static EntityArgumentType entities() {
        return new EntityArgumentType(false, false);
    }

    public static EntityArgumentType entity() {
        return new EntityArgumentType(true, false);
    }

    public static EntityArgumentType players() {
        return new EntityArgumentType(false, true);
    }

    public static EntityArgumentType player() {
        return new EntityArgumentType(true, true);
    }

    @Override
    public EntitySelector parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        EntitySelectorParser entitySelectorParser = new EntitySelectorParser(reader);
        EntitySelector entitySelector = entitySelectorParser.parse();
        if (this.singleEntity && entitySelector.getMaxResults() > 1) {
            reader.setCursor(cursor);
            if (this.playerOnly) {
                throw CommandExceptions.singlePlayerOnly().createWithContext(reader);
            }
            throw CommandExceptions.singleEntityOnly().createWithContext(reader);
        }
        if (this.playerOnly && entitySelector.includesEntities() && !entitySelector.isCurrentEntity()) {
            reader.setCursor(cursor);
            throw CommandExceptions.playerOnly().createWithContext(reader);
        }
        return entitySelector;
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        S s = context.getSource();
        if (s instanceof CommandSource) {
            CommandSource source = (CommandSource)s;
            StringReader stringReader = new StringReader(builder.getInput());
            stringReader.setCursor(builder.getStart());
            EntitySelectorParser entitySelectorParser = new EntitySelectorParser(stringReader, source.hasAdmin());
            try {
                entitySelectorParser.parse();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entitySelectorParser.fillSuggestions(builder, suggestionsBuilder -> {
                Collection<String> collection = source.getPlayerNames();
                Iterable<String> iterable = this.playerOnly ? collection : new ConcatIterable<String>(collection, source.getEntitySuggestions());
                CommandHelper.suggest(iterable, suggestionsBuilder);
            });
        }
        return Suggestions.empty();
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

