/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.EntityArgumentType;
import net.minecraft.core.net.command.arguments.SoundCategoryArgumentType;
import net.minecraft.core.net.command.arguments.SoundIdArgumentType;
import net.minecraft.core.net.command.arguments.Vec3ArgumentType;
import net.minecraft.core.net.command.helpers.DoubleCoordinates;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public class PlaySoundCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("playsound").requires(CommandSource::hasAdmin)).then(RequiredArgumentBuilder.argument("soundId", SoundIdArgumentType.soundId()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("type", SoundCategoryArgumentType.soundCategory()).executes(c -> {
            String soundId = c.getArgument("soundId", String.class);
            SoundCategory category = c.getArgument("type", SoundCategory.class);
            Player player = ((CommandSource)c.getSource()).getSender();
            World world = ((CommandSource)c.getSource()).getWorld();
            if (player != null) {
                world.playSoundEffect(player, category, player.x, player.y, player.z, soundId, 1.0f, 1.0f);
                return 1;
            }
            return 0;
        })).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("position", Vec3ArgumentType.vec3d()).executes(c -> {
            String soundId = c.getArgument("soundId", String.class);
            SoundCategory category = c.getArgument("type", SoundCategory.class);
            DoubleCoordinates coordinates = c.getArgument("position", DoubleCoordinates.class);
            Vec3 coords = ((CommandSource)c.getSource()).getCoordinates(true);
            double sourceX = coords == null ? 0.0 : coords.x;
            double sourceY = coords == null ? 0.0 : coords.y;
            double sourceZ = coords == null ? 0.0 : coords.z;
            World world = ((CommandSource)c.getSource()).getWorld();
            world.playSoundEffect(null, category, coordinates.getX(sourceX), coordinates.getY(sourceY), coordinates.getZ(sourceZ), soundId, 1.0f, 1.0f);
            return 1;
        })).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("volume", FloatArgumentType.floatArg()).executes(c -> {
            String soundId = c.getArgument("soundId", String.class);
            SoundCategory category = c.getArgument("type", SoundCategory.class);
            DoubleCoordinates coordinates = c.getArgument("position", DoubleCoordinates.class);
            float volume = c.getArgument("volume", Float.class).floatValue();
            Vec3 coords = ((CommandSource)c.getSource()).getCoordinates(true);
            double sourceX = coords == null ? 0.0 : coords.x;
            double sourceY = coords == null ? 0.0 : coords.y;
            double sourceZ = coords == null ? 0.0 : coords.z;
            World world = ((CommandSource)c.getSource()).getWorld();
            world.playSoundEffect(null, category, coordinates.getX(sourceX), coordinates.getY(sourceY), coordinates.getZ(sourceZ), soundId, volume, 1.0f);
            return 1;
        })).then(RequiredArgumentBuilder.argument("pitch", FloatArgumentType.floatArg()).executes(c -> {
            String soundId = c.getArgument("soundId", String.class);
            SoundCategory category = c.getArgument("type", SoundCategory.class);
            DoubleCoordinates coordinates = c.getArgument("position", DoubleCoordinates.class);
            float volume = c.getArgument("volume", Float.class).floatValue();
            float pitch = c.getArgument("pitch", Float.class).floatValue();
            Vec3 coords = ((CommandSource)c.getSource()).getCoordinates(true);
            double sourceX = coords == null ? 0.0 : coords.x;
            double sourceY = coords == null ? 0.0 : coords.y;
            double sourceZ = coords == null ? 0.0 : coords.z;
            World world = ((CommandSource)c.getSource()).getWorld();
            world.playSoundEffect(null, category, coordinates.getX(sourceX), coordinates.getY(sourceY), coordinates.getZ(sourceZ), soundId, volume, pitch);
            return 1;
        }))))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("target", EntityArgumentType.entities()).executes(c -> {
            String soundId = c.getArgument("soundId", String.class);
            SoundCategory category = c.getArgument("type", SoundCategory.class);
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> targets = entitySelector.get((CommandSource)c.getSource());
            World world = ((CommandSource)c.getSource()).getWorld();
            for (Entity entity : targets) {
                world.playSoundEffect(null, category, entity.x, entity.y, entity.z, soundId, 1.0f, 1.0f);
            }
            return 1;
        })).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("volume", FloatArgumentType.floatArg()).executes(c -> {
            String soundId = c.getArgument("soundId", String.class);
            SoundCategory category = c.getArgument("type", SoundCategory.class);
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> targets = entitySelector.get((CommandSource)c.getSource());
            float volume = c.getArgument("volume", Float.class).floatValue();
            World world = ((CommandSource)c.getSource()).getWorld();
            for (Entity entity : targets) {
                world.playSoundEffect(null, category, entity.x, entity.y, entity.z, soundId, volume, 1.0f);
            }
            return 1;
        })).then(RequiredArgumentBuilder.argument("pitch", FloatArgumentType.floatArg()).executes(c -> {
            String soundId = c.getArgument("soundId", String.class);
            SoundCategory category = c.getArgument("type", SoundCategory.class);
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> targets = entitySelector.get((CommandSource)c.getSource());
            float volume = c.getArgument("volume", Float.class).floatValue();
            float pitch = c.getArgument("pitch", Float.class).floatValue();
            World world = ((CommandSource)c.getSource()).getWorld();
            for (Entity entity : targets) {
                world.playSoundEffect(null, category, entity.x, entity.y, entity.z, soundId, volume, pitch);
            }
            return 1;
        })))))));
    }
}

