/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import java.util.ArrayList;
import net.minecraft.core.item.ItemStack;

public abstract class InventorySorter {
    public static void sortInventory(ItemStack[] inventory) {
        InventorySorter.sortInventory(inventory, 0, inventory.length - 1);
    }

    public static void sortInventory(ItemStack[] inventory, int startIndex, int endIndex) {
        int i;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (i = startIndex; i <= endIndex; ++i) {
            if (inventory[i] == null) continue;
            items.add(inventory[i]);
            inventory[i] = null;
        }
        items.sort((a, b) -> {
            int aId = a.itemID;
            int bId = b.itemID;
            if (aId == bId) {
                return 0;
            }
            if (aId < bId) {
                return -1;
            }
            return 1;
        });
        for (i = 0; i < items.size(); ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.stackSize >= stack.getMaxStackSize()) continue;
            int remaining = stack.getMaxStackSize() - stack.stackSize;
            for (int j = i + 1; j < items.size(); ++j) {
                ItemStack nextStack = (ItemStack)items.get(j);
                if (!stack.canStackWith(nextStack)) continue;
                ++i;
                if (remaining <= 0) continue;
                if (nextStack.stackSize <= remaining) {
                    remaining -= nextStack.stackSize;
                    items.remove(nextStack);
                    --i;
                    --j;
                    continue;
                }
                nextStack.stackSize -= remaining;
                remaining = 0;
            }
            stack.stackSize = stack.getMaxStackSize() - remaining;
        }
        items.sort((a, b) -> {
            int aId = a.itemID;
            int bId = b.itemID;
            if (aId == bId) {
                return a.stackSize - b.stackSize;
            }
            if (aId < bId) {
                return -1;
            }
            return 1;
        });
        for (i = 0; i < items.size(); ++i) {
            inventory[startIndex + i] = (ItemStack)items.get(i);
        }
    }
}

