/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.menu;

import java.util.List;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.AbstractContainerMenu;
import net.minecraft.core.player.inventory.slot.DyeSlot;
import net.minecraft.core.player.inventory.slot.Slot;

public class FlagMenu
extends AbstractContainerMenu {
    public FlagBlockEntity flag;

    public FlagMenu(Container inv, FlagBlockEntity flag) {
        this.flag = flag;
        this.addSlot(new DyeSlot(flag, 36, 129, 10));
        this.addSlot(new DyeSlot(flag, 37, 129, 32));
        this.addSlot(new DyeSlot(flag, 38, 129, 54));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot(inv, x + y * 9 + 9, 8 + x * 18, 113 + y * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot(inv, i, 8 + i * 18, 171));
        }
    }

    @Override
    public List<Integer> getMoveSlots(InventoryAction action, Slot slot, int target, Player player) {
        if (slot.index >= 0 && slot.index <= 2) {
            return this.getSlots(0, 3, false);
        }
        if (action == InventoryAction.MOVE_SIMILAR) {
            return this.getSlots(3, 36, false);
        }
        if (action == InventoryAction.MOVE_ALL) {
            if (slot.index < 27) {
                return this.getSlots(3, 27, false);
            }
            return this.getSlots(30, 9, false);
        }
        return null;
    }

    @Override
    public List<Integer> getTargetSlots(InventoryAction action, Slot slot, int target, Player player) {
        if (slot.index >= 0 && slot.index <= 2) {
            return this.getSlots(3, 36, false);
        }
        return this.getSlots(0, 3, false);
    }

    @Override
    public boolean stillValid(Player entityplayer) {
        return this.flag.stillValid(entityplayer);
    }
}

