/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.menu;

import java.util.List;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.CraftingContainer;
import net.minecraft.core.player.inventory.container.Inventory;
import net.minecraft.core.player.inventory.container.ResultContainer;
import net.minecraft.core.player.inventory.menu.AbstractContainerMenu;
import net.minecraft.core.player.inventory.slot.ArmorSlot;
import net.minecraft.core.player.inventory.slot.ResultSlot;
import net.minecraft.core.player.inventory.slot.Slot;

public class InventoryMenu
extends AbstractContainerMenu {
    public CraftingContainer craftSlots = new CraftingContainer(this, 2, 2);
    public Container resultSlots = new ResultContainer();
    public boolean active;
    public Inventory inventory;

    public InventoryMenu(Inventory inventory) {
        this(inventory, true);
    }

    public InventoryMenu(Inventory inventory, boolean active) {
        int i;
        this.active = active;
        this.inventory = inventory;
        this.addSlot(new ResultSlot(inventory.player, this.craftSlots, this.resultSlots, 0, 144, 36));
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new Slot(this.craftSlots, j + i * 2, 88 + j * 18, 26 + i * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            int armorType = 3 - i;
            this.addSlot(new ArmorSlot(this, inventory, inventory.getContainerSize() - 1 - i, 8, 8 + i * 18, armorType));
        }
        for (i = 0; i < 3; ++i) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlot(new Slot(inventory, k1 + (i + 1) * 9, 8 + k1 * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot(inventory, i, 8 + i * 18, 142));
        }
        this.slotsChanged(this.craftSlots);
    }

    @Override
    public void slotsChanged(Container iinventory) {
        this.resultSlots.setItem(0, Registries.RECIPES.findMatchingRecipe(this.craftSlots));
    }

    @Override
    public void onCraftGuiClosed(Player player) {
        super.onCraftGuiClosed(player);
        boolean insert = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack itemstack = this.craftSlots.getItem(i);
            if (itemstack == null) continue;
            this.craftSlots.setItem(i, null);
            this.storeOrDropItem(player, itemstack);
            insert = true;
        }
        if (insert) {
            player.world.playSoundAtEntity(null, player, "random.insert", 0.1f, 1.0f);
        }
    }

    @Override
    public boolean stillValid(Player entityplayer) {
        return true;
    }

    @Override
    public List<Integer> getMoveSlots(InventoryAction action, Slot slot, int target, Player player) {
        if (slot.index == 0) {
            return this.getSlots(0, 1, false);
        }
        if (slot.index >= 1 && slot.index <= 4) {
            return this.getSlots(1, 4, false);
        }
        if (slot.index >= 5 && slot.index <= 8) {
            return this.getSlots(5, 4, false);
        }
        if (action == InventoryAction.MOVE_SIMILAR) {
            if (slot.index >= 9 && slot.index <= 44) {
                return this.getSlots(9, 36, false);
            }
        } else {
            if (slot.index >= 9 && slot.index <= 35) {
                return this.getSlots(9, 27, false);
            }
            if (slot.index >= 36 && slot.index <= 44) {
                return this.getSlots(36, 9, false);
            }
        }
        return null;
    }

    @Override
    public List<Integer> getTargetSlots(InventoryAction action, Slot slot, int target, Player player) {
        if (slot.index >= 9 && slot.index <= 44) {
            if (target == 1) {
                return this.getSlots(1, 4, false);
            }
            if (target == 2) {
                return this.getSlots(5, 4, false);
            }
            if (slot.index < 36) {
                return this.getSlots(36, 9, false);
            }
            return this.getSlots(9, 27, false);
        }
        if (slot.index == 0) {
            return this.getSlots(9, 36, true);
        }
        return this.getSlots(9, 36, false);
    }
}

