/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.command;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.LoggedPrintStream;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.command.IServerCommandSource;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ConsoleCommandSource
implements CommandSource,
IServerCommandSource {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final MinecraftServer server;

    public ConsoleCommandSource(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public Collection<String> getPlayerNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Player player : this.server.playerList.playerEntities) {
            list.add(player.username);
        }
        return list;
    }

    @Override
    public Collection<String> getEntitySuggestions() {
        return this.getPlayerNames();
    }

    @Override
    public String toString() {
        return "ConsoleCommandSource{" + this.server + "}";
    }

    @Override
    public Player getSender() {
        return null;
    }

    @Override
    public boolean hasAdmin() {
        return true;
    }

    @Override
    @Nullable
    public Vec3 getCoordinates(boolean offsetHeight) {
        return null;
    }

    @Override
    @Nullable
    public Vec3 getBlockCoordinates() {
        return null;
    }

    @Override
    public boolean messageMayBeMultiline() {
        return true;
    }

    @Override
    public void sendMessage(String message) {
        LOGGER.info(LoggedPrintStream.removeColorCodes(message));
    }

    @Override
    public void sendMessage(Player player, String message) {
        this.server.playerList.sendPacketToPlayer(player.username, new ChatPacket(message, AES.keyChain.get(player.username)));
    }

    @Override
    public void sendMessageToAllPlayers(String message) {
        this.getServer().playerList.sendPacketToAllPlayers(new ChatPacket(message));
    }

    @Override
    public World getWorld() {
        return this.server.getDimensionWorld(0);
    }

    @Override
    public World getWorld(int dimension) {
        return this.server.getDimensionWorld(dimension);
    }

    @Override
    public void movePlayerToDimension(Player player, int dimension) {
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalStateException("Player is not an instance of ServerPlayer");
        }
        this.server.playerList.sendPlayerToOtherDimension((ServerPlayer)player, dimension, false);
    }

    @Override
    public String getName() {
        return "Server";
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }
}

