/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import java.util.Objects;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlock<T extends BlockLogic>
extends Item {
    @NotNull
    protected Block<T> block;

    public ItemBlock(@NotNull Block<T> block) {
        super(block.namespaceId(), block.id());
        this.block = Objects.requireNonNull(block);
        this.setKey(block.getKey());
    }

    @NotNull
    public Block<T> getBlock() {
        return this.block;
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack stack, @Nullable Player player, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        if (stack.stackSize <= 0) {
            return false;
        }
        if (!world.canPlaceInsideBlock(x, y, z)) {
            x += side.getOffsetX();
            y += side.getOffsetY();
            z += side.getOffsetZ();
        }
        if (y < 0 || y >= world.getHeightBlocks()) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.block.id(), x, y, z, false, side)) {
            int meta = this.getPlacedBlockMetadata(player, stack, world, x, y, z, side, xPlaced, yPlaced);
            if (world.setBlockAndMetadataWithNotify(x, y, z, this.block.id(), meta)) {
                stack.consumeItem(player);
                if (player == null) {
                    this.block.onBlockPlacedOnSide(world, x, y, z, side, xPlaced, yPlaced);
                } else {
                    this.block.onBlockPlacedByMob(world, x, y, z, side, player, xPlaced, yPlaced);
                }
                world.playBlockSoundEffect(player, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        int z;
        int y;
        int x = blockX + direction.getOffsetX();
        Block<?> b = world.getBlock(x, y = blockY + direction.getOffsetY(), z = blockZ + direction.getOffsetZ());
        if (b == null || BlockTags.PLACE_OVERWRITES.appliesTo(b)) {
            this.onUseItemOnBlock(itemStack, null, world, x, y, z, direction.getSide(), 0.5, 0.5);
        }
    }

    public int getPlacedBlockMetadata(@Nullable Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        return this.block.getPlacedBlockMetadata(player, stack, world, x, y, z, side, xPlaced, yPlaced);
    }

    @Override
    public String getLanguageKey(ItemStack itemstack) {
        return this.block.getLanguageKey(itemstack.getMetadata());
    }

    @Override
    public String getKey() {
        return this.block.getKey();
    }
}

