/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.chunk.perlin.DensityGenerator;
import net.minecraft.core.world.generate.chunk.perlin.TerrainGeneratorLerp;
import net.minecraft.core.world.generate.chunk.perlin.nether.DensityGeneratorNether;
import net.minecraft.core.world.type.WorldType;

public class TerrainGeneratorNether
extends TerrainGeneratorLerp {
    private final DensityGenerator densityGenerator;

    public TerrainGeneratorNether(World world) {
        super(world);
        this.densityGenerator = new DensityGeneratorNether(world);
    }

    @Override
    protected int getBlockAt(int x, int y, int z, double density) {
        WorldType type = this.world.getWorldType();
        int halfHeight = type.getMaxY() / 2;
        if (y >= type.getMaxY() - this.rand.nextInt(5)) {
            return Blocks.BEDROCK.id();
        }
        if (y >= halfHeight - this.rand.nextInt(5) && y <= halfHeight + 5 - this.rand.nextInt(5)) {
            return Blocks.BONESHALE.id();
        }
        if (y <= type.getMinY() + this.rand.nextInt(5)) {
            return Blocks.BEDROCK.id();
        }
        if (y <= halfHeight) {
            return Blocks.SOULSCHIST.id();
        }
        if (density > 0.0) {
            return type.getFillerBlockId();
        }
        if (y >= halfHeight && y < type.getOceanY()) {
            return type.getOceanBlockId();
        }
        return 0;
    }

    @Override
    public DensityGenerator getDensityGenerator() {
        return this.densityGenerator;
    }
}

