/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.weather;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.weather.Weather;

public class WeatherSnow
extends Weather {
    public WeatherSnow(int id) {
        super(id);
    }

    @Override
    public String getPrecipitationTexture(World world) {
        if (world.weatherManager.getWeatherPower() <= 0.6f) {
            return "/assets/minecraft/textures/environment/snow_light.png";
        }
        return "/assets/minecraft/textures/environment/snow.png";
    }

    @Override
    public void doChunkLoadEffect(World world, Chunk chunk) {
        if (world.weatherManager.getWeatherPower() <= 0.6f) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            int worldX = chunk.xPosition * 16 + x;
            block1: for (int z = 0; z < 16; ++z) {
                int y = chunk.getHeightValue(x, z);
                int worldZ = chunk.zPosition * 16 + z;
                Biome biome = world.getBlockBiome(worldX, y, worldZ);
                for (int i = 0; i < biome.blockedWeathers.length; ++i) {
                    if (biome.blockedWeathers[i] == this) continue block1;
                }
                int blockId = chunk.getBlockID(x, y, z);
                int blockIdBelow = chunk.getBlockID(x, y - 1, z);
                if (y < 0 || y >= world.getHeightBlocks() || chunk.getBrightness(LightLayer.Block, x, y, z) >= 10) continue;
                if (blockId == 0 && Blocks.LAYER_SNOW.canPlaceBlockAt(world, worldX, y, worldZ) && blockIdBelow != Blocks.ICE.id()) {
                    chunk.setBlockIDWithMetadataRaw(x, y, z, Blocks.LAYER_SNOW.id(), chunk.getBlockMetadata(x, y, z));
                    continue;
                }
                if (blockIdBelow != Blocks.FLUID_WATER_STILL.id() || chunk.getBlockMetadata(x, y - 1, z) != 0) continue;
                chunk.setBlockIDWithMetadataRaw(x, y - 1, z, Blocks.ICE.id(), chunk.getBlockMetadata(x, y - 1, z));
                if (chunk.getBlockID(x, y - 2, z) != Blocks.FLUID_WATER_STILL.id()) continue;
                chunk.setBlockIDWithMetadataRaw(x, y - 2, z, Blocks.FLUID_WATER_FLOWING.id(), chunk.getBlockMetadata(x, y - 2, z));
            }
        }
    }

    @Override
    public void doEnvironmentUpdate(World world, Random rand, int x, int z) {
        block4: {
            int i;
            int blockIdBelow;
            int y;
            block6: {
                Biome biome;
                int blockId;
                boolean snow;
                block5: {
                    int probability = (int)(64.0f * (1.0f / world.weatherManager.getWeatherPower()));
                    if (world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().hasDeeperSnow) {
                        probability /= 2;
                    }
                    snow = rand.nextInt(probability) == 0;
                    y = world.findTopSolidBlock(x, z);
                    blockId = world.getBlockId(x, y, z);
                    blockIdBelow = world.getBlockId(x, y - 1, z);
                    biome = world.getBlockBiome(x, y, z);
                    for (i = 0; i < biome.blockedWeathers.length; ++i) {
                        if (biome.blockedWeathers[i] != this) continue;
                        return;
                    }
                    if (!(world.weatherManager.getWeatherPower() > 0.6f) || y < 0 || y >= world.getHeightBlocks() || world.getSavedLightValue(LightLayer.Block, x, y, z) >= 10) break block4;
                    if (blockId != 0 || blockIdBelow == 0 || !Blocks.LAYER_SNOW.canPlaceBlockAt(world, x, y, z) || blockIdBelow == Blocks.ICE.id()) break block5;
                    if (!snow) break block4;
                    world.setBlockWithNotify(x, y, z, Blocks.LAYER_SNOW.id());
                    break block4;
                }
                if (!(world.weatherManager.getWeatherPower() > 0.5f) || blockId != Blocks.LAYER_SNOW.id() || world.getSeasonManager().getCurrentSeason() == null || !world.getSeasonManager().getCurrentSeason().hasDeeperSnow && biome != Biomes.OVERWORLD_GLACIER) break block6;
                if (!snow) break block4;
                Blocks.LAYER_SNOW.getLogic().accumulate(world, x, y, z);
                break block4;
            }
            if (blockIdBelow == Blocks.FLUID_WATER_STILL.id() && world.getBlockMetadata(x, y - 1, z) == 0 && rand.nextFloat() < world.weatherManager.getWeatherPower() * world.weatherManager.getWeatherIntensity()) {
                for (i = 0; i < 4; ++i) {
                    Direction direction = Direction.horizontalDirections[i];
                    Block<?> block = world.getBlock(x + direction.getOffsetX(), y - 1, z + direction.getOffsetZ());
                    if (block != Blocks.ICE && (block == null || !block.isSolidRender())) continue;
                    world.setBlockWithNotify(x, y - 1, z, Blocks.ICE.id());
                    break;
                }
            }
        }
    }
}

