/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRail;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.MinecartEntity;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockLogicRailDetector
extends BlockLogicRail {
    public BlockLogicRailDetector(Block<?> block) {
        super(block, true);
        block.setTicking(true);
    }

    @Override
    public int tickDelay() {
        return 20;
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 8) == 0) {
            this.checkForMinecart(world, x, y, z, meta);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 8) != 0) {
            this.checkForMinecart(world, x, y, z, meta);
        }
    }

    @Override
    public boolean getSignal(WorldSource worldSource, int x, int y, int z, Side side) {
        return (worldSource.getBlockMetadata(x, y, z) & 8) != 0;
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        if ((world.getBlockMetadata(x, y, z) & 8) == 0) {
            return false;
        }
        return side == Side.TOP;
    }

    private void checkForMinecart(World world, int x, int y, int z, int meta) {
        boolean isPowered = (meta & 8) != 0;
        boolean minecartPresent = false;
        float offset = 0.125f;
        List<MinecartEntity> list = world.getEntitiesWithinAABB(MinecartEntity.class, AABB.getTemporaryBB((float)x + offset, (float)y + offset, (float)z + offset, (float)(x + 1) - offset, (float)(y + 1) - offset, (float)(z + 1) - offset));
        if (!list.isEmpty()) {
            minecartPresent = true;
        }
        if (minecartPresent && !isPowered) {
            world.setBlockMetadataWithNotify(x, y, z, meta | 8);
            world.notifyBlocksOfNeighborChange(x, y, z, this.id());
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id());
            world.markBlockDirty(x, y, z);
        }
        if (!minecartPresent && isPowered) {
            world.setBlockMetadataWithNotify(x, y, z, meta & 0xFFFFFFF7);
            world.notifyBlocksOfNeighborChange(x, y, z, this.id());
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id());
            world.markBlockDirty(x, y, z);
        }
        if (minecartPresent) {
            world.scheduleBlockUpdate(x, y, z, this.id(), this.tickDelay());
        }
    }
}

