/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.world.World;

public class BlockLogicFireCold
extends BlockLogicFire {
    public BlockLogicFireCold(Block<?> block) {
        super(block);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        boolean infiniBurn;
        Block<?> blockUnder = world.getBlock(x, y - 1, z);
        boolean bl = infiniBurn = blockUnder != null && blockUnder.hasTag(BlockTags.INFINITE_BURN_COLD) || world.getGameRuleValue(GameRules.DO_FIRE_SPREAD) == false;
        if (!this.isValidFireLocation(world, x, y, z)) {
            this.setBurnResult(world, x, y, z);
        }
        if (!infiniBurn && world.getCurrentWeather() != null && world.getCurrentWeather().isPrecipitation && (world.canBlockBeRainedOn(x, y, z) || world.canBlockBeRainedOn(x - 1, y, z) || world.canBlockBeRainedOn(x + 1, y, z) || world.canBlockBeRainedOn(x, y, z - 1) || world.canBlockBeRainedOn(x, y, z + 1))) {
            this.setBurnResult(world, x, y, z);
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if (meta < 15) {
            world.setBlockMetadata(x, y, z, meta + rand.nextInt(3) / 2);
        }
        world.scheduleBlockUpdate(x, y, z, this.block.id(), this.tickDelay());
        if (!infiniBurn && !this.canNeighborCatchFire(world, x, y, z)) {
            if (!world.isBlockNormalCube(x, y - 1, z) || meta > 3) {
                this.setBurnResult(world, x, y, z);
            }
            return;
        }
        if (!infiniBurn && !BlockLogicFireCold.canBurn(world, x, y - 1, z) && meta == 15 && rand.nextInt(4) == 0) {
            this.setBurnResult(world, x, y, z);
            return;
        }
    }
}

