/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobMonsterArmored;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobSkeleton
extends MobMonsterArmored<HumanArmorShape> {
    public static final int DATA_ATTACK_TIME = 15;
    private static final ItemStack defaultHeldItem = new ItemStack(Items.TOOL_BOW, 1);

    public MobSkeleton(World world) {
        super(world);
        this.textureIdentifier = new NamespaceID("minecraft", "skeleton");
        this.scoreValue = 500;
        this.mobDrops.add(new WeightedRandomLootObject(Items.AMMO_ARROW.getDefaultStack(), 0, 2));
        this.mobDrops.add(new WeightedRandomLootObject(Items.BONE.getDefaultStack(), 0, 2));
        HashMap itemsMapMap = new HashMap();
        HashMap<HumanArmorShape, Item> itemsMap = new HashMap<HumanArmorShape, Item>();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_LEATHER);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_LEATHER);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_LEATHER);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_LEATHER);
        itemsMapMap.put(ArmorMaterial.LEATHER, itemsMap);
        itemsMap = new HashMap();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_IRON);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_IRON);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_IRON);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_IRON);
        itemsMapMap.put(ArmorMaterial.IRON, itemsMap);
        itemsMap = new HashMap();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_GOLD);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_GOLD);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_GOLD);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_GOLD);
        itemsMapMap.put(ArmorMaterial.GOLD, itemsMap);
        itemsMap = new HashMap();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_CHAINMAIL);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_CHAINMAIL);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_CHAINMAIL);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_CHAINMAIL);
        itemsMapMap.put(ArmorMaterial.CHAINMAIL, itemsMap);
        itemsMap = new HashMap();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_DIAMOND);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_DIAMOND);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_DIAMOND);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_DIAMOND);
        itemsMapMap.put(ArmorMaterial.DIAMOND, itemsMap);
        itemsMap = new HashMap();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_STEEL);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_STEEL);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_STEEL);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_STEEL);
        itemsMapMap.put(ArmorMaterial.STEEL, itemsMap);
        Random rand = new Random();
        for (HumanArmorShape shape : HumanArmorShape.values()) {
            ArmorMaterial mat = ArmorMaterial.getArmorMaterials().get(rand.nextInt(ArmorMaterial.getArmorMaterials().size()));
            this.setItemInArmorSlot(shape, new ItemStack((Item)((Map)itemsMapMap.get(mat)).get(shape)));
        }
    }

    @Override
    public String getLivingSound() {
        return "mob.skeleton";
    }

    @Override
    protected String getHurtSound() {
        return "mob.skeletonhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.skeletonhurt";
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(15, this.attackTime, Integer.class);
    }

    @Override
    public void onLivingUpdate() {
        Weather weather;
        float f;
        if (this.world.isClientSide) {
            this.attackTime = this.entityData.getInt(15);
        } else {
            this.entityData.set(15, this.attackTime);
        }
        if (this.world.isDaytime() && (f = this.getBrightness(1.0f)) > 0.5f && this.world.canBlockSeeTheSky(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && (weather = this.world.getCurrentWeather()) != null && !weather.isDamp && (weather != Weathers.OVERWORLD_FOG || this.world.weatherManager.getWeatherPower() < 0.75f)) {
            this.remainingFireTicks = 300;
        }
        super.onLivingUpdate();
    }

    @Override
    protected void attackEntity(@NotNull Entity entity, float distance) {
        if (distance < 10.0f) {
            double d = entity.x - this.x;
            double d1 = entity.z - this.z;
            if (this.attackTime == 0) {
                if (!this.world.isClientSide) {
                    ProjectileArrow arrow = new ProjectileArrow(this.world, this, false, 0);
                    double d2 = entity.y + (double)entity.getHeadHeight() - 0.2 - arrow.y;
                    float f1 = MathHelper.sqrt(d * d + d1 * d1) * 0.2f;
                    this.world.playSoundAtEntity(null, this, "random.bow", 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.8f));
                    arrow.setHeading(d, d2 + (double)f1, d1, 0.6f, 12.0f);
                    this.world.entityJoinedWorld(arrow);
                }
                this.attackTime = 30;
            }
            this.yRot = (float)(Math.atan2(d1, d) * 180.0 / Math.PI) - 90.0f;
            this.hasAttacked = true;
        }
    }

    @Override
    public ItemStack getHeldItem() {
        return defaultHeldItem;
    }

    @Override
    public int getNumArmorSlots() {
        return HumanArmorShape.values().length;
    }

    @Override
    @Nullable
    public HumanArmorShape getArmorSlotByIndex(int index) {
        if (index < 0 || index >= HumanArmorShape.values().length) {
            return null;
        }
        return HumanArmorShape.values()[index];
    }
}

