/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.monster.MobMonsterArmored;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.Nullable;

public class MobZombie
extends MobMonsterArmored<HumanArmorShape> {
    public MobZombie(World world) {
        super(world);
        this.textureIdentifier = new NamespaceID("minecraft", "zombie");
        this.moveSpeed = 0.5f;
        this.attackStrength = 5;
        this.scoreValue = 300;
        this.mobDrops.add(new WeightedRandomLootObject(Items.CLOTH.getDefaultStack(), 0, 2));
        HashMap itemsMapMap = new HashMap();
        HashMap<HumanArmorShape, Item> itemsMap = new HashMap<HumanArmorShape, Item>();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_LEATHER);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_LEATHER);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_LEATHER);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_LEATHER);
        itemsMapMap.put(ArmorMaterial.LEATHER, itemsMap);
        itemsMap = new HashMap();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_IRON);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_IRON);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_IRON);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_IRON);
        itemsMapMap.put(ArmorMaterial.IRON, itemsMap);
        itemsMap = new HashMap();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_GOLD);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_GOLD);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_GOLD);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_GOLD);
        itemsMapMap.put(ArmorMaterial.GOLD, itemsMap);
        itemsMap = new HashMap();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_CHAINMAIL);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_CHAINMAIL);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_CHAINMAIL);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_CHAINMAIL);
        itemsMapMap.put(ArmorMaterial.CHAINMAIL, itemsMap);
        itemsMap = new HashMap();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_DIAMOND);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_DIAMOND);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_DIAMOND);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_DIAMOND);
        itemsMapMap.put(ArmorMaterial.DIAMOND, itemsMap);
        itemsMap = new HashMap();
        itemsMap.put(HumanArmorShape.BOOTS, Items.ARMOR_BOOTS_STEEL);
        itemsMap.put(HumanArmorShape.LEGS, Items.ARMOR_LEGGINGS_STEEL);
        itemsMap.put(HumanArmorShape.CHEST, Items.ARMOR_CHESTPLATE_STEEL);
        itemsMap.put(HumanArmorShape.HEAD, Items.ARMOR_CHESTPLATE_STEEL);
        itemsMapMap.put(ArmorMaterial.STEEL, itemsMap);
        Random rand = new Random();
        for (HumanArmorShape shape : HumanArmorShape.values()) {
            ArmorMaterial mat = ArmorMaterial.getArmorMaterials().get(rand.nextInt(ArmorMaterial.getArmorMaterials().size()));
            this.setItemInArmorSlot(shape, new ItemStack((Item)((Map)itemsMapMap.get(mat)).get(shape)));
        }
    }

    @Override
    public void onLivingUpdate() {
        if (this.world.isDaytime()) {
            float f = this.getBrightness(1.0f);
            Weather weather = this.world.getCurrentWeather();
            if (f > 0.5f && this.world.canBlockSeeTheSky(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && weather != null && !weather.isDamp && (this.world.getCurrentWeather() != Weathers.OVERWORLD_FOG || this.world.weatherManager.getWeatherPower() < 0.75f)) {
                this.remainingFireTicks = 300;
            }
        }
        super.onLivingUpdate();
    }

    @Override
    public String getLivingSound() {
        return "mob.zombie";
    }

    @Override
    protected String getHurtSound() {
        return "mob.zombiehurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.zombiedeath";
    }

    @Override
    public int getNumArmorSlots() {
        return HumanArmorShape.values().length;
    }

    @Override
    @Nullable
    public HumanArmorShape getArmorSlotByIndex(int index) {
        if (index < 0 || index >= HumanArmorShape.values().length) {
            return null;
        }
        return HumanArmorShape.values()[index];
    }
}

