/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemStatue
extends Item {
    protected final Block<?> statueBlockBottom;
    protected final Block<?> statueBlockTop;

    public ItemStatue(String name, String namespaceId, int id, Block<?> statueBlockBottom, Block<?> statueBlockTop) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
        this.statueBlockBottom = statueBlockBottom;
        this.statueBlockTop = statueBlockTop;
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (!this.statueBlockBottom.canPlaceBlockAt(world, blockX, blockY, blockZ)) {
            return false;
        }
        world.noNeighborUpdate = true;
        world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.statueBlockBottom.id(), MathHelper.floor((double)((player.yRot + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        world.setBlockAndMetadataWithNotify(blockX, blockY + 1, blockZ, this.statueBlockTop.id(), MathHelper.floor((double)((player.yRot + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockX, blockY, blockZ, this.statueBlockBottom.id());
        world.notifyBlocksOfNeighborChange(blockX, blockY + 1, blockZ, this.statueBlockTop.id());
        world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.statueBlockBottom, EnumBlockSoundEffectType.PLACE);
        this.statueBlockBottom.onBlockPlacedByMob(world, blockX, blockY, blockZ, side, player, xPlaced, yPlaced);
        this.statueBlockTop.onBlockPlacedByMob(world, blockX, blockY + 1, blockZ, side, player, xPlaced, yPlaced);
        itemstack.consumeItem(player);
        return true;
    }

    @Override
    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += direction.getOffsetX();
            blockY += direction.getOffsetY();
            blockZ += direction.getOffsetZ();
        }
        if (!this.statueBlockBottom.canPlaceBlockAt(world, blockX, blockY, blockZ)) {
            return;
        }
        world.noNeighborUpdate = true;
        world.setBlockWithNotify(blockX, blockY, blockZ, this.statueBlockBottom.id());
        world.setBlockWithNotify(blockX, blockY + 1, blockZ, this.statueBlockTop.id());
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockX, blockY, blockZ, this.statueBlockBottom.id());
        world.notifyBlocksOfNeighborChange(blockX, blockY + 1, blockZ, this.statueBlockTop.id());
        world.playBlockSoundEffect(null, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.statueBlockBottom, EnumBlockSoundEffectType.PLACE);
        this.statueBlockBottom.onBlockPlacedOnSide(world, blockX, blockY, blockZ, direction.getSide(), 0.5, 0.5);
        this.statueBlockTop.onBlockPlacedOnSide(world, blockX, blockY + 1, blockZ, direction.getSide(), 0.5, 0.5);
        itemStack.consumeItem(null);
    }
}

