/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;

public class CommandSeed
implements CommandManager.CommandRegistry {
    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("seed").requires(CommandSource::hasAdmin)).executes(c -> {
            Clipboard clipboard;
            CommandSource source = (CommandSource)c.getSource();
            source.sendTranslatableMessage("command.commands.seed.success", source.getWorld().getRandomSeed());
            if (source.getSender() != null && (clipboard = Toolkit.getDefaultToolkit().getSystemClipboard()) != null) {
                try {
                    clipboard.setContents(new StringSelection(String.valueOf(source.getWorld().getRandomSeed())), null);
                    source.sendTranslatableMessage("command.commands.seed.copied_to_clipboard", new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 1;
        }));
    }
}

