/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.world.Dimension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.net.command.IServerCommandSource;
import net.minecraft.server.world.WorldServer;

public class CommandSave
implements CommandManager.CommandRegistry {
    private static final DynamicCommandExceptionType FAILURE = new DynamicCommandExceptionType(arg -> () -> I18n.getInstance().translateKeyAndFormat("command.commands.save.exception_failure", arg));

    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("save").then(LiteralArgumentBuilder.literal("all").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            MinecraftServer server = ((IServerCommandSource)((Object)source)).getServer();
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.save.start", new Object[0]);
            if (server.playerList != null) {
                server.playerList.savePlayerStates();
            }
            for (WorldServer worldServer : server.dimensionWorlds.values()) {
                worldServer.saveWorld(true, null, worldServer.dimension == Dimension.OVERWORLD);
            }
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.save.end", new Object[0]);
            return 1;
        }))).then(LiteralArgumentBuilder.literal("on").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            MinecraftServer server = ((IServerCommandSource)((Object)source)).getServer();
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.save.on", new Object[0]);
            for (WorldServer worldServer : server.dimensionWorlds.values()) {
                worldServer.dontSave = false;
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("off").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            MinecraftServer server = ((IServerCommandSource)((Object)source)).getServer();
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.save.off", new Object[0]);
            for (WorldServer worldServer : server.dimensionWorlds.values()) {
                worldServer.dontSave = true;
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("interval").then(RequiredArgumentBuilder.argument("value", IntegerArgumentType.integer()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            MinecraftServer server = ((IServerCommandSource)((Object)source)).getServer();
            int interval = c.getArgument("value", Integer.class);
            server.propertyManager.setProperty("autosaveInterval", interval);
            server.autoSaveInterval = interval;
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.save.interval", interval);
            return 1;
        })))).then(LiteralArgumentBuilder.literal("amount").then(RequiredArgumentBuilder.argument("value", IntegerArgumentType.integer()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            MinecraftServer server = ((IServerCommandSource)((Object)source)).getServer();
            int amount = c.getArgument("value", Integer.class);
            server.propertyManager.setProperty("maxChunksSavedPerAutosave", amount);
            server.chunksSavedPerAutosave = amount;
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.save.amount", amount);
            return 1;
        }))));
    }
}

