/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net;

import net.minecraft.server.net.PlayerHashEntry;

public class PlayerHash {
    private transient PlayerHashEntry[] hashArray = new PlayerHashEntry[16];
    private transient int numHashElements;
    private int capacity = 12;
    private final float percentUsable = 0.75f;
    private volatile transient int field_950_e;

    private static int getHashedKey(long l) {
        return PlayerHash.hash((int)(l ^ l >>> 32));
    }

    private static int hash(int i) {
        i ^= i >>> 20 ^ i >>> 12;
        return i ^ i >>> 7 ^ i >>> 4;
    }

    private static int getHashIndex(int i, int j) {
        return i & j - 1;
    }

    public Object getValueByKey(long l) {
        int i = PlayerHash.getHashedKey(l);
        PlayerHashEntry playerhashentry = this.hashArray[PlayerHash.getHashIndex(i, this.hashArray.length)];
        while (playerhashentry != null) {
            if (playerhashentry.key == l) {
                return playerhashentry.value;
            }
            playerhashentry = playerhashentry.nextEntry;
        }
        return null;
    }

    public void add(long l, Object obj) {
        int i = PlayerHash.getHashedKey(l);
        int j = PlayerHash.getHashIndex(i, this.hashArray.length);
        PlayerHashEntry playerhashentry = this.hashArray[j];
        while (playerhashentry != null) {
            if (playerhashentry.key == l) {
                playerhashentry.value = obj;
            }
            playerhashentry = playerhashentry.nextEntry;
        }
        ++this.field_950_e;
        this.createKey(i, l, obj, j);
    }

    private void resizeTable(int i) {
        PlayerHashEntry[] aplayerhashentry = this.hashArray;
        int j = aplayerhashentry.length;
        if (j == 0x40000000) {
            this.capacity = Integer.MAX_VALUE;
            return;
        }
        PlayerHashEntry[] aplayerhashentry1 = new PlayerHashEntry[i];
        this.copyHashTableTo(aplayerhashentry1);
        this.hashArray = aplayerhashentry1;
        this.capacity = (int)((float)i * 0.75f);
    }

    private void copyHashTableTo(PlayerHashEntry[] aplayerhashentry) {
        PlayerHashEntry[] aplayerhashentry1 = this.hashArray;
        int i = aplayerhashentry.length;
        for (int j = 0; j < aplayerhashentry1.length; ++j) {
            PlayerHashEntry playerhashentry1;
            PlayerHashEntry playerhashentry = aplayerhashentry1[j];
            if (playerhashentry == null) continue;
            aplayerhashentry1[j] = null;
            do {
                playerhashentry1 = playerhashentry.nextEntry;
                int k = PlayerHash.getHashIndex(playerhashentry.field_1026_d, i);
                playerhashentry.nextEntry = aplayerhashentry[k];
                aplayerhashentry[k] = playerhashentry;
            } while ((playerhashentry = playerhashentry1) != null);
        }
    }

    public Object remove(long l) {
        PlayerHashEntry playerhashentry = this.removeKey(l);
        return playerhashentry != null ? playerhashentry.value : null;
    }

    final PlayerHashEntry removeKey(long l) {
        PlayerHashEntry playerhashentry;
        int i = PlayerHash.getHashedKey(l);
        int j = PlayerHash.getHashIndex(i, this.hashArray.length);
        PlayerHashEntry playerhashentry1 = playerhashentry = this.hashArray[j];
        while (playerhashentry1 != null) {
            PlayerHashEntry playerhashentry2 = playerhashentry1.nextEntry;
            if (playerhashentry1.key == l) {
                ++this.field_950_e;
                --this.numHashElements;
                if (playerhashentry == playerhashentry1) {
                    this.hashArray[j] = playerhashentry2;
                } else {
                    playerhashentry.nextEntry = playerhashentry2;
                }
                return playerhashentry1;
            }
            playerhashentry = playerhashentry1;
            playerhashentry1 = playerhashentry2;
        }
        return playerhashentry1;
    }

    private void createKey(int i, long l, Object obj, int j) {
        PlayerHashEntry playerhashentry = this.hashArray[j];
        this.hashArray[j] = new PlayerHashEntry(i, l, obj, playerhashentry);
        if (this.numHashElements++ >= this.capacity) {
            this.resizeTable(2 * this.hashArray.length);
        }
    }

    static int getHashCode(long l) {
        return PlayerHash.getHashedKey(l);
    }
}

