/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFarmland;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public class BlockLogicCropsWheat
extends BlockLogicFlower
implements IBonemealable {
    public static final int MASK_GROWTH = 7;
    public static final int MAX_GROWTH_STATE = 7;

    public BlockLogicCropsWheat(Block<?> block) {
        super(block);
        block.setTicking(true);
        float f = 0.5f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, 0.25, 0.5f + f);
    }

    @Override
    public boolean mayPlaceOn(int blockId) {
        return blockId == Blocks.FARMLAND_DIRT.id();
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        float f;
        int l;
        super.updateTick(world, x, y, z, rand);
        if (world.getBlockLightValue(x, y + 1, z) >= 9 && (l = world.getBlockMetadata(x, y, z)) < 7 && rand.nextInt((int)(100.0f / (f = this.getGrowthRate(world, x, y, z)))) == 0) {
            world.setBlockMetadataWithNotify(x, y, z, ++l);
        }
    }

    public void fertilize(World world, int x, int y, int z) {
        world.setBlockMetadataWithNotify(x, y, z, 7);
    }

    private float getGrowthRate(World world, int x, int y, int z) {
        boolean isFertilized;
        float growthRate = 1.0f;
        int idNegZ = world.getBlockId(x, y, z - 1);
        int idPosZ = world.getBlockId(x, y, z + 1);
        int idNegX = world.getBlockId(x - 1, y, z);
        int idPosX = world.getBlockId(x + 1, y, z);
        int idNegXNegZ = world.getBlockId(x - 1, y, z - 1);
        int idPosXNegZ = world.getBlockId(x + 1, y, z - 1);
        int idPosXPosZ = world.getBlockId(x + 1, y, z + 1);
        int idNegXPosZ = world.getBlockId(x - 1, y, z + 1);
        boolean xNeighbor = idNegX == this.block.id() || idPosX == this.block.id();
        boolean zNeighbor = idNegZ == this.block.id() || idPosZ == this.block.id();
        boolean diagNeighbor = idNegXNegZ == this.block.id() || idPosXNegZ == this.block.id() || idPosXPosZ == this.block.id() || idNegXPosZ == this.block.id();
        for (int dx = x - 1; dx <= x + 1; ++dx) {
            for (int dz = z - 1; dz <= z + 1; ++dz) {
                int id = world.getBlockId(dx, y - 1, dz);
                float growthRateMod = 0.0f;
                if (id == Blocks.FARMLAND_DIRT.id()) {
                    growthRateMod = 1.0f;
                    if (world.getBlockMetadata(dx, y - 1, dz) > 0) {
                        growthRateMod = 3.0f;
                    }
                }
                if (dx != x || dz != z) {
                    growthRateMod /= 4.0f;
                }
                growthRate += growthRateMod;
            }
        }
        if (diagNeighbor || xNeighbor && zNeighbor) {
            growthRate /= 2.0f;
        }
        if (!(isFertilized = BlockLogicFarmland.isFertilized(world.getBlockMetadata(x, y - 1, z)))) {
            if (world.getSeasonManager().getCurrentSeason() != null) {
                growthRate *= world.getSeasonManager().getCurrentSeason().cropGrowthFactor;
            }
        } else {
            growthRate *= 1.5f;
        }
        return growthRate;
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, Side side, int meta, Player player, Item item) {
        boolean isFertilized = BlockLogicFarmland.isFertilized(world.getBlockMetadata(x, y - 1, z));
        if (isFertilized && !world.isClientSide) {
            boolean shouldDefertilize;
            boolean bl = shouldDefertilize = world.rand.nextInt(3) == 2;
            if (shouldDefertilize) {
                world.setBlockMetadata(x, y - 1, z, BlockLogicFarmland.setFertilized(world.getBlockMetadata(x, y - 1, z), false));
            }
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        if (meta != 7) {
            return new ItemStack[]{new ItemStack(Items.SEEDS_WHEAT)};
        }
        return new ItemStack[]{new ItemStack(Items.SEEDS_WHEAT, world.rand.nextInt(3) + 1), new ItemStack(Items.WHEAT)};
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, @Nullable Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockMetadata(blockX, blockY, blockZ) < 7) {
            if (!world.isClientSide) {
                this.fertilize(world, blockX, blockY, blockZ);
                if (player == null || player.getGamemode().consumeBlocks()) {
                    --itemstack.stackSize;
                }
            }
            return true;
        }
        return false;
    }
}

