/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public abstract class BlockLogicFluid
extends BlockLogic {
    public BlockLogicFluid(Block<?> block, Material material) {
        super(block, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        block.setTicking(true);
    }

    public static float getWaterVolume(int data) {
        if ((data &= 0xF) >= 8) {
            data = 0;
        }
        return (float)(data + 1) / 8.0f;
    }

    protected int getDepth(WorldSource world, int x, int y, int z) {
        if (world.getBlockMaterial(x, y, z) != this.material) {
            return -1;
        }
        return world.getBlockMetadata(x, y, z) & 0xF;
    }

    protected int getRenderedDepth(WorldSource blockAccess, int x, int y, int z) {
        if (blockAccess.getBlockMaterial(x, y, z) != this.material) {
            return -1;
        }
        int meta = blockAccess.getBlockMetadata(x, y, z) & 0xF;
        if (meta >= 8) {
            meta = 0;
        }
        return meta;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean canCollideCheck(int meta, boolean shouldCollideWithFluids) {
        return shouldCollideWithFluids && (meta & 0xF) == 0;
    }

    @Override
    public boolean getIsBlockSolid(WorldSource blockAccess, int x, int y, int z, Side side) {
        Material material = blockAccess.getBlockMaterial(x, y, z);
        if (material == this.material) {
            return false;
        }
        if (material == Material.ice) {
            return false;
        }
        if (side == Side.TOP) {
            return true;
        }
        return super.getIsBlockSolid(blockAccess, x, y, z, side);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    private Vec3 getFlow(WorldSource world, int x, int y, int z) {
        Vec3 result = Vec3.getTempVec3(0.0, 0.0, 0.0);
        int depthLocal = this.getRenderedDepth(world, x, y, z);
        for (int i = 0; i < 4; ++i) {
            int mult;
            int depthCheck;
            int checkX = x;
            int checkY = y;
            int checkZ = z;
            if (i == 0) {
                --checkX;
            }
            if (i == 1) {
                --checkZ;
            }
            if (i == 2) {
                ++checkX;
            }
            if (i == 3) {
                ++checkZ;
            }
            if ((depthCheck = this.getRenderedDepth(world, checkX, checkY, checkZ)) < 0) {
                if (world.getBlockMaterial(checkX, checkY, checkZ).blocksMotion() || (depthCheck = this.getRenderedDepth(world, checkX, checkY - 1, checkZ)) < 0) continue;
                mult = depthCheck - (depthLocal - 8);
                result = result.add((checkX - x) * mult, (checkY - y) * mult, (checkZ - z) * mult);
                continue;
            }
            mult = depthCheck - depthLocal;
            result = result.add((checkX - x) * mult, (checkY - y) * mult, (checkZ - z) * mult);
        }
        result = result.normalize();
        return result;
    }

    @Override
    public void handleEntityInside(World world, int x, int y, int z, Entity entity, Vec3 entityVelocity) {
        if (entity.noPhysics) {
            return;
        }
        Vec3 flowVector = this.getFlow(world, x, y, z);
        entityVelocity.x += flowVector.x;
        entityVelocity.y += flowVector.y;
        entityVelocity.z += flowVector.z;
    }

    @Override
    public int tickDelay() {
        if (this.material == Material.water) {
            return 5;
        }
        return this.material != Material.lava ? 0 : 30;
    }

    @Override
    public float getBlockBrightness(WorldSource world, int x, int y, int z) {
        float f = world.getLightBrightness(x, y, z);
        float f1 = world.getLightBrightness(x, y + 1, z);
        return Math.max(f, f1);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        boolean isTop;
        int data = world.getBlockMetadata(x, y, z) & 0xF;
        boolean bl = isTop = world.getBlockMaterial(x, y + 1, z) == Material.air && !world.isBlockOpaqueCube(x, y + 1, z);
        if (this.material == Material.water && rand.nextInt(64) == 0 && data > 0 && data < 8) {
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "liquid.water", rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() * 1.0f + 0.5f);
        }
        if (this.material == Material.water && world.dimension == Dimension.NETHER && isTop && data == 0 && rand.nextInt(4) == 0) {
            world.spawnParticle("smoke", (double)x + Math.random(), (float)y + 0.875f, (double)z + Math.random(), 0.0, 0.0, 0.0, 1);
        }
        if (this.material == Material.lava && isTop && rand.nextInt(100) == 0) {
            double xOff = (double)x + (double)rand.nextFloat();
            double yOff = (double)y + this.getBounds().maxY;
            double zOff = (double)z + (double)rand.nextFloat();
            world.spawnParticle("lava", xOff, yOff, zOff, 0.0, 0.0, 0.0, 0);
        }
    }

    public static double getSlopeAngle(WorldSource blockAccess, int x, int y, int z, Material material) {
        Vec3 vec3 = null;
        if (material == Material.water) {
            vec3 = Blocks.FLUID_WATER_FLOWING.getLogic().getFlow(blockAccess, x, y, z);
        }
        if (material == Material.lava) {
            vec3 = Blocks.FLUID_LAVA_FLOWING.getLogic().getFlow(blockAccess, x, y, z);
        }
        if (vec3 == null || vec3.x == 0.0 && vec3.z == 0.0) {
            return -1000.0;
        }
        return Math.atan2(vec3.z, vec3.x) - 1.5707963267948966;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        this.checkForHarden(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.checkForHarden(world, x, y, z);
    }

    private void checkForHarden(World world, int x, int y, int z) {
        int data;
        if (world.getBlockId(x, y, z) != this.block.id()) {
            return;
        }
        if (this.material == Material.lava && (world.getBlockMaterial(x, y, z - 1) == Material.water || world.getBlockMaterial(x, y, z + 1) == Material.water || world.getBlockMaterial(x - 1, y, z) == Material.water || world.getBlockMaterial(x + 1, y, z) == Material.water || world.getBlockMaterial(x, y + 1, z) == Material.water)) {
            data = world.getBlockMetadata(x, y, z) & 0xF;
            if (data == 0) {
                if (world.dimension == Dimension.NETHER) {
                    world.setBlockWithNotify(x, y, z, Blocks.COBBLE_NETHERRACK_IGNEOUS.id());
                } else {
                    world.setBlockWithNotify(x, y, z, Blocks.OBSIDIAN.id());
                }
            } else if (data <= 2) {
                world.setBlockWithNotify(x, y, z, Blocks.COBBLE_GRANITE.id());
            } else if (data <= 4) {
                world.setBlockWithNotify(x, y, z, Blocks.COBBLE_STONE.id());
            } else {
                world.setBlockWithNotify(x, y, z, Blocks.COBBLE_BASALT.id());
            }
            this.fizz(world, x, y, z);
        }
        if (this.material == Material.water && (world.getBlockMaterial(x, y, z - 1) == Material.lava || world.getBlockMaterial(x, y, z + 1) == Material.lava || world.getBlockMaterial(x - 1, y, z) == Material.lava || world.getBlockMaterial(x + 1, y, z) == Material.lava || world.getBlockMaterial(x, y + 1, z) == Material.lava) && (data = world.getBlockMetadata(x, y, z) & 0xF) == 0) {
            world.setBlockWithNotify(x, y, z, Blocks.COBBLE_LIMESTONE.id());
            this.fizz(world, x, y, z);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return null;
    }

    protected void fizz(World world, int x, int y, int z) {
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + 1.2, (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        float f7 = BlockLogicFluid.getFluidHeight(world, x, y, z, this.material);
        float f8 = BlockLogicFluid.getFluidHeight(world, x, y, z + 1, this.material);
        float f9 = BlockLogicFluid.getFluidHeight(world, x + 1, y, z + 1, this.material);
        float f10 = BlockLogicFluid.getFluidHeight(world, x + 1, y, z, this.material);
        return AABB.getTemporaryBB(0.0, 0.0, 0.0, 1.0, Math.max((double)((f7 + f8 + f9 + f10) / 4.0f), 0.2), 1.0);
    }

    public static float getFluidHeight(WorldSource worldSource, int x, int y, int z, Material material) {
        int l = 0;
        float f = 0.0f;
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = x - (i1 & 1);
            int l1 = z - (i1 >> 1 & 1);
            if (worldSource.getBlockMaterial(j1, y + 1, l1) == material) {
                return 1.0f;
            }
            Material material1 = worldSource.getBlockMaterial(j1, y, l1);
            if (material1 == material) {
                int i2 = worldSource.getBlockMetadata(j1, y, l1);
                if (i2 >= 8 || i2 == 0) {
                    f += BlockLogicFluid.getWaterVolume(i2) * 10.0f;
                    l += 10;
                }
                f += BlockLogicFluid.getWaterVolume(i2);
                ++l;
                continue;
            }
            if (material1.isSolid()) continue;
            f += 1.0f;
            ++l;
        }
        return Math.max(1.0f - f / (float)l, 0.015f);
    }
}

