/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.tags.CompoundTag;
import java.util.UUID;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.util.helper.UUIDHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntitySign
extends TileEntity {
    public static final int MAX_LINE_SIZE = 15;
    public String[] signText = new String[]{"", "", "", ""};
    public int lineBeingEdited = -1;
    private int selectedPicture = 0;
    private int selectedColor = 15;
    @Nullable
    private UUID owner;
    private boolean glowing = false;

    @Override
    public void writeAdditionalData(@NotNull CompoundTag compoundTag) {
        compoundTag.putString("Text1", this.signText[0]);
        compoundTag.putString("Text2", this.signText[1]);
        compoundTag.putString("Text3", this.signText[2]);
        compoundTag.putString("Text4", this.signText[3]);
        compoundTag.putInt("Picture", this.selectedPicture);
        compoundTag.putInt("Color", this.selectedColor);
        compoundTag.putBoolean("Glowing", this.glowing);
        UUIDHelper.writeToTag(compoundTag, this.owner, "OwnerUUID");
    }

    @Override
    public void readAdditionalData(@NotNull CompoundTag compoundTag) {
        for (int i = 0; i < 4; ++i) {
            this.signText[i] = compoundTag.getString("Text" + (i + 1));
            if (this.signText[i].length() <= 15) continue;
            this.signText[i] = this.signText[i].substring(0, 15);
        }
        this.selectedPicture = compoundTag.getIntegerOrDefault("Picture", 0);
        this.selectedColor = compoundTag.getIntegerOrDefault("Color", 15);
        this.glowing = compoundTag.getBooleanOrDefault("Glowing", false);
        UUID ownerUUID = UUIDHelper.readFromTag(compoundTag, "OwnerUUID");
        if (ownerUUID == null) {
            String s = compoundTag.getString("Owner");
            if (!s.isEmpty()) {
                UUIDHelper.runConversionAction(s, uuid -> {
                    this.owner = uuid;
                }, null);
            }
        } else {
            this.owner = ownerUUID;
        }
    }

    public boolean isEditableBy(Player player) {
        return player.uuid.equals(this.owner);
    }

    public void setOwner(Player player) {
        this.owner = player.uuid;
    }

    public EnumSignPicture getPicture() {
        if (this.selectedPicture < 0) {
            return null;
        }
        for (EnumSignPicture picture : EnumSignPicture.values()) {
            if (picture.getId() != this.selectedPicture) continue;
            return picture;
        }
        return null;
    }

    public void setPicture(EnumSignPicture picture) {
        if (picture == null) {
            this.selectedPicture = 0;
            return;
        }
        this.selectedPicture = picture.getId();
    }

    public TextFormatting getColor() {
        if (this.selectedColor < 0 || this.selectedColor > 15) {
            return TextFormatting.BLACK;
        }
        return TextFormatting.FORMATTINGS[this.selectedColor];
    }

    public void setColor(TextFormatting color) {
        this.selectedColor = color.id;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
    }

    @Override
    public Packet getDescriptionPacket() {
        return new PacketTileEntityData(this);
    }
}

