/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome.provider;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.noise.PerlinSimplexNoise;
import net.minecraft.core.world.type.WorldTypes;

public final class BiomeProviderNether
extends BiomeProvider {
    private static final Biome[] biomesOrder = new Biome[]{Biomes.NETHER_BONEYARD, Biomes.NETHER_ASH_PLAINS, Biomes.NETHER_CRYSTAL_FOREST, Biomes.NETHER_SULFUR_POOLS, Biomes.NETHER_NETHER, Biomes.NETHER_VOLCANIC_ISLANDS};
    private final PerlinSimplexNoise temperatureNoise;
    private final PerlinSimplexNoise fuzzinessNoise;
    private double temperatureXScale = 0.0125;
    private double temperatureZScale = 0.0125;
    private double temperatureExponent = 0.25;
    private double temperatureFuzzPercentage = 0.01;
    private double fuzzinessXScale = 0.25;
    private double fuzzinessZScale = 0.25;
    private double fuzzinessExponent = 1.0;

    public BiomeProviderNether(long seed) {
        this.temperatureNoise = new PerlinSimplexNoise(new Random(seed * 5345L), 4);
        this.fuzzinessNoise = new PerlinSimplexNoise(new Random(seed * 35864L), 2);
    }

    @Override
    public Biome[] getBiomes(Biome[] biomes, double[] temperatures, double[] humidities, double[] varieties, int x, int y, int z, int xSize, int ySize, int zSize) {
        if (biomes == null || biomes.length < xSize * ySize * zSize) {
            biomes = new Biome[xSize * ySize * zSize];
        }
        if (temperatures == null || temperatures.length < xSize * zSize) {
            temperatures = this.getTemperatures(temperatures, x, z, xSize, zSize);
        }
        if (humidities == null || humidities.length < xSize * zSize) {
            humidities = this.getHumidities(humidities, x, z, xSize, zSize);
        }
        if (varieties == null || varieties.length < xSize * zSize) {
            varieties = this.getVarieties(varieties, x, z, xSize, zSize);
        }
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double temperature = temperatures[dx * zSize + dz];
                double humidity = humidities[dx * zSize + dz];
                double variety = varieties[dx * zSize + dz];
                for (int dy = 0; dy < ySize; ++dy) {
                    double altitude = WorldTypes.NETHER_DEFAULT.getYPercentage(y + dy << 3);
                    biomes[dy * xSize * zSize + dz * xSize + dx] = this.lookupBiome(temperature, humidity, altitude, variety);
                }
            }
        }
        return biomes;
    }

    public double getTemperature(double x, double z) {
        double[] fnResult;
        double fuzziness;
        double fuzzPctg;
        double valPctg;
        double[] tnResult = this.temperatureNoise.getValue(null, x, z, 1, 1, this.temperatureXScale, this.temperatureZScale, this.temperatureExponent);
        double temperature = (tnResult[0] * 0.15 + 0.7) * (valPctg = 1.0 - (fuzzPctg = this.temperatureFuzzPercentage)) + (fuzziness = (fnResult = this.fuzzinessNoise.getValue(null, x, z, 1, 1, this.fuzzinessXScale, this.fuzzinessZScale, this.fuzzinessExponent))[0] * 1.1 + 0.5) * fuzzPctg;
        if (temperature < 0.0) {
            temperature = 0.0;
        }
        if (temperature > 1.0) {
            temperature = 1.0;
        }
        return temperature;
    }

    @Override
    public double[] getTemperatures(double[] temperatures, int x, int z, int xSize, int zSize) {
        if (temperatures == null || temperatures.length < xSize * zSize) {
            temperatures = new double[xSize * zSize];
        }
        double[] tnResult = this.temperatureNoise.getValue(null, x, z, xSize, zSize, this.temperatureXScale, this.temperatureZScale, this.temperatureExponent);
        double[] fnResult = this.fuzzinessNoise.getValue(null, x, z, xSize, zSize, this.fuzzinessXScale, this.fuzzinessZScale, this.fuzzinessExponent);
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double fuzzPctg = this.temperatureFuzzPercentage;
                double valPctg = 1.0 - fuzzPctg;
                double fuzziness = fnResult[dx * zSize + dz] * 1.1 + 0.5;
                double temperature = (tnResult[dx * zSize + dz] * 0.15 + 0.7) * valPctg + fuzziness * fuzzPctg;
                if (temperature < 0.0) {
                    temperature = 0.0;
                }
                if (temperature > 1.0) {
                    temperature = 1.0;
                }
                temperatures[dx * zSize + dz] = temperature;
            }
        }
        return temperatures;
    }

    @Override
    public double[] getHumidities(double[] humidities, int x, int z, int xSize, int zSize) {
        if (humidities == null || humidities.length < xSize * zSize) {
            humidities = new double[xSize * zSize];
        }
        return humidities;
    }

    @Override
    public double[] getVarieties(double[] varieties, int x, int z, int xSize, int zSize) {
        if (varieties == null || varieties.length < xSize * zSize) {
            varieties = new double[xSize * zSize];
        }
        return varieties;
    }

    @Override
    public double[] getBiomenesses(double[] biomenesses, int x, int y, int z, int xSize, int ySize, int zSize) {
        if (biomenesses == null || biomenesses.length < xSize * ySize * zSize) {
            biomenesses = new double[xSize * ySize * zSize];
        }
        Arrays.fill(biomenesses, 1.0);
        return biomenesses;
    }

    @Override
    public Biome lookupBiome(double temperature, double humidity, double altitude, double variety) {
        for (int i = 0; i < biomesOrder.length; ++i) {
            if (!(temperature <= 1.0 / (double)biomesOrder.length * (double)(i + 1))) continue;
            return biomesOrder[i];
        }
        return Biomes.NETHER_NETHER;
    }

    public void getOverlap(double temperature, BiomeOverlapPair toUpdate) {
        float overlapAmount = 1.0f / (float)(biomesOrder.length * 4);
        for (int i = 0; i < biomesOrder.length; ++i) {
            float minStrict = 1.0f / (float)biomesOrder.length * (float)i;
            float maxStrict = 1.0f / (float)biomesOrder.length * (float)(i + 1);
            float minOuter = minStrict - overlapAmount;
            float maxOuter = maxStrict + overlapAmount;
            float minInner = minStrict + overlapAmount;
            float maxInner = maxStrict - overlapAmount;
            if (i == 0 && temperature < (double)minInner || i == biomesOrder.length - 1 && temperature >= (double)maxInner) {
                toUpdate.hasOverlap = false;
                toUpdate.biomeA = biomesOrder[i];
                toUpdate.biomeAPercentage = 1.0f;
                return;
            }
            if (temperature >= (double)minInner && temperature < (double)maxInner) {
                toUpdate.hasOverlap = false;
                toUpdate.biomeA = biomesOrder[i];
                toUpdate.biomeAPercentage = 1.0f;
                return;
            }
            if (!(temperature >= (double)minOuter) || !(temperature < (double)maxOuter)) continue;
            if (temperature < (double)minInner) {
                toUpdate.hasOverlap = true;
                toUpdate.biomeA = biomesOrder[i - 1];
                toUpdate.biomeB = biomesOrder[i];
                float range = minInner - minOuter;
                temperature -= (double)minOuter;
                toUpdate.biomeAPercentage = 1.0f - (float)(temperature /= (double)range);
                toUpdate.biomeBPercentage = (float)temperature;
                return;
            }
            if (!(temperature >= (double)maxInner)) continue;
            toUpdate.hasOverlap = true;
            toUpdate.biomeA = biomesOrder[i];
            toUpdate.biomeB = biomesOrder[i + 1];
            float range = maxOuter - maxInner;
            temperature -= (double)maxInner;
            toUpdate.biomeAPercentage = 1.0f - (float)(temperature /= (double)range);
            toUpdate.biomeBPercentage = (float)temperature;
            return;
        }
        toUpdate.hasOverlap = false;
        toUpdate.biomeA = Biomes.NETHER_NETHER;
        toUpdate.biomeAPercentage = 1.0f;
    }

    public static class BiomeOverlapPair {
        public boolean hasOverlap;
        public Biome biomeA;
        public Biome biomeB;
        public float biomeAPercentage;
        public float biomeBPercentage;
    }
}

