/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ByteArrayTag
extends Tag<byte[]> {
    public ByteArrayTag() {
        this(new byte[0]);
    }

    public ByteArrayTag(byte[] array) {
        super(array);
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        dos.writeInt(((byte[])this.getValue()).length);
        dos.write((byte[])this.getValue());
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        int length = dis.readInt();
        this.setValue(new byte[length]);
        dis.readFully((byte[])this.getValue());
    }

    @Override
    public byte getId() {
        return 7;
    }

    public String toString() {
        if (((byte[])this.getValue()).length > 16) {
            return "\"" + this.getTagName() + "\": [ " + ((byte[])this.getValue()).length + " bytes ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getTagName()).append("\": [ ");
        for (byte b : (byte[])this.getValue()) {
            sb.append(b).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ByteArrayTag)) {
            return false;
        }
        ByteArrayTag otherTag = (ByteArrayTag)obj;
        byte[] thisData = (byte[])this.getValue();
        byte[] otherData = (byte[])otherTag.getValue();
        return Arrays.equals(thisData, otherData);
    }
}

