/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FloatTag
extends Tag<Float> {
    public FloatTag() {
        this(0.0f);
    }

    public FloatTag(float value) {
        super(Float.valueOf(value));
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        dos.writeFloat(((Float)this.getValue()).floatValue());
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        this.setValue(Float.valueOf(dis.readFloat()));
    }

    @Override
    public byte getId() {
        return 5;
    }

    public String toString() {
        return "\"" + this.getTagName() + "\": " + this.getValue();
    }
}

