/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.enums.IArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.material.ArmorMaterial;
import org.jetbrains.annotations.NotNull;

public class ItemArmor<T extends IArmorShape>
extends Item
implements IArmorItem<T> {
    private final ArmorMaterial material;
    private final T armorShape;

    public ItemArmor(@NotNull String name, @NotNull String namespaceId, int id, ArmorMaterial material, @NotNull T armorShape) {
        super(name, namespaceId, id);
        this.material = material;
        this.armorShape = armorShape;
        this.setMaxDamage((int)(armorShape.getDurabilityModifier() * (float)material.durability));
        this.maxStackSize = 1;
    }

    @Override
    public ArmorMaterial getArmorMaterial() {
        return this.material;
    }

    @Override
    @NotNull
    public T getArmorShape() {
        return this.armorShape;
    }
}

