/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.net.command.CommandSource;
import org.jetbrains.annotations.Nullable;

public class CommandManager {
    private final boolean isServer;
    private final CommandDispatcher<CommandSource> DISPATCHER = new CommandDispatcher();
    private static final Collection<CommandRegistry> externalCommands = new ArrayList<CommandRegistry>();
    private static final Collection<CommandRegistry> externalServerCommands = new ArrayList<CommandRegistry>();

    public CommandManager(boolean isServer) {
        this.isServer = isServer;
    }

    public void init() {
        if (this.isServer) {
            for (CommandRegistry registry : externalServerCommands) {
                registry.register(this.DISPATCHER);
            }
        }
        for (CommandRegistry registry : externalCommands) {
            registry.register(this.DISPATCHER);
        }
    }

    public int execute(String s, CommandSource commandSource) throws CommandSyntaxException {
        return this.DISPATCHER.execute(s, commandSource);
    }

    public CommandDispatcher<CommandSource> getDispatcher() {
        return this.DISPATCHER;
    }

    @Nullable
    public static <S> CommandSyntaxException getParseException(ParseResults<S> parseResults) {
        if (!parseResults.getReader().canRead()) {
            return null;
        }
        if (parseResults.getExceptions().size() == 1) {
            return parseResults.getExceptions().values().iterator().next();
        }
        if (parseResults.getContext().getRange().isEmpty()) {
            return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseResults.getReader());
        }
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parseResults.getReader());
    }

    public static void registerCommand(CommandRegistry registry) {
        externalCommands.add(registry);
    }

    public static void registerServerCommand(CommandRegistry registry) {
        externalServerCommands.add(registry);
    }

    @FunctionalInterface
    public static interface CommandRegistry {
        public void register(CommandDispatcher<CommandSource> var1);
    }
}

