/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class DoubleArrayTag
extends Tag<double[]> {
    public DoubleArrayTag() {
        this(new double[0]);
    }

    public DoubleArrayTag(double[] array) {
        super(array);
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        dos.writeInt(((double[])this.getValue()).length);
        byte[] bytes = new byte[((double[])this.getValue()).length * 8];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().put((double[])this.getValue());
        dos.write(bytes);
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        int length = dis.readInt();
        this.setValue(new double[length]);
        byte[] bytes = new byte[length * 8];
        dis.readFully(bytes);
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().get((double[])this.getValue());
    }

    @Override
    public byte getId() {
        return 12;
    }

    public String toString() {
        if (((double[])this.getValue()).length > 16) {
            return "\"" + this.getTagName() + "\": [ " + ((double[])this.getValue()).length + " doubles ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getTagName()).append("\": [ ");
        for (double d : (double[])this.getValue()) {
            sb.append(d).append(", ");
        }
        sb.append("];");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleArrayTag)) {
            return false;
        }
        DoubleArrayTag otherTag = (DoubleArrayTag)obj;
        double[] thisData = (double[])this.getValue();
        double[] otherData = (double[])otherTag.getValue();
        return Arrays.equals(thisData, otherData);
    }
}

