/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.server.entity.player.PlayerServer;
import net.minecraft.server.net.command.IServerCommandSource;

public class CommandColor
implements CommandManager.CommandRegistry {
    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode<CommandSource> command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("color").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("get").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            PlayerServer player = (PlayerServer)source.getSender();
            if (player == null) {
                throw CommandExceptions.notInWorld().create();
            }
            TextFormatting color = TextFormatting.get(player.chatColor);
            source.sendMessage(I18n.getInstance().translateKeyAndFormat("command.commands.color.get.success", color + color.getNames()[0]));
            return 1;
        })).then(RequiredArgumentBuilder.argument("target", ArgumentTypeEntity.player()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            PlayerServer player = (PlayerServer)entitySelector.get(source).get(0);
            TextFormatting color = TextFormatting.get(player.chatColor);
            source.sendMessage(I18n.getInstance().translateKeyAndFormat("command.commands.color.get.success_other", color + color.getNames()[0]));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("set").then(LiteralArgumentBuilder.literal("white").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)0);
        }))).then(LiteralArgumentBuilder.literal("orange").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)1);
        }))).then(LiteralArgumentBuilder.literal("magenta").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)2);
        }))).then(LiteralArgumentBuilder.literal("light_blue").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)3);
        }))).then(LiteralArgumentBuilder.literal("yellow").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)4);
        }))).then(LiteralArgumentBuilder.literal("lime").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)5);
        }))).then(LiteralArgumentBuilder.literal("pink").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)6);
        }))).then(LiteralArgumentBuilder.literal("gray").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)7);
        }))).then(LiteralArgumentBuilder.literal("light_gray").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)8);
        }))).then(LiteralArgumentBuilder.literal("cyan").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)9);
        }))).then(LiteralArgumentBuilder.literal("purple").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)10);
        }))).then(LiteralArgumentBuilder.literal("blue").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)11);
        }))).then(LiteralArgumentBuilder.literal("brown").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)12);
        }))).then(LiteralArgumentBuilder.literal("green").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)13);
        }))).then(LiteralArgumentBuilder.literal("red").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)14);
        }))).then(LiteralArgumentBuilder.literal("black").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            return CommandColor.setColor((PlayerServer)source.getSender(), source, (byte)15);
        }))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("target", ArgumentTypeEntity.players()).requires(CommandSource::hasAdmin)).then(LiteralArgumentBuilder.literal("white").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)0);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("orange").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)1);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("magenta").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)2);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("light_blue").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)3);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("yellow").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)4);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("lime").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)5);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("pink").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)6);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("gray").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)7);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("light_gray").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)8);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("cyan").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)9);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("purple").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)10);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("blue").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)11);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("brown").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)12);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("green").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)13);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("red").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)14);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("black").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            for (Entity entity : entities) {
                CommandColor.setColor((PlayerServer)entity, source, (byte)15);
            }
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("colour").redirect(command));
    }

    private static int setColor(PlayerServer player, CommandSource source, byte colorId) throws CommandSyntaxException {
        if (!(source instanceof IServerCommandSource)) {
            throw CommandExceptions.multiplayerWorldOnly().create();
        }
        if (player == null) {
            throw CommandExceptions.notInWorld().create();
        }
        player.chatColor = colorId;
        TextFormatting color = TextFormatting.get(colorId);
        if (player == source.getSender()) {
            source.sendTranslatableMessage("command.commands.color.set.success", color + color.getNames()[0]);
        } else {
            source.sendTranslatableMessage("command.commands.color.set.success_other", CommandHelper.getEntityName(player), color + color.getNames()[0]);
            source.sendTranslatableMessage(player, "command.commands.color.set.success_receiver", color + color.getNames()[0]);
        }
        return 1;
    }
}

