/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.World;
import net.minecraft.core.world.wind.WindProvider;

public class BlockLogicLeavesOak
extends BlockLogicLeavesBase {
    public BlockLogicLeavesOak(Block<?> block) {
        super(block, Material.leaves, Blocks.SAPLING_OAK);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
        if (rand.nextInt(128) == 0 && world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().hasFallingLeaves) {
            int id;
            for (int q = -1; q > -16 && (id = world.getBlockId(x, y + q, z)) == 0; --q) {
                if (Blocks.LAYER_LEAVES_OAK.canPlaceBlockAt(world, x, y + q, z) && Blocks.blocksList[world.getBlockId(x, y + q - 1, z)].getMaterial().blocksMotion()) {
                    world.setBlockWithNotify(x, y + q, z, Blocks.LAYER_LEAVES_OAK.id());
                    break;
                }
                if (world.getBlockId(x, y + q, z) != Blocks.LAYER_LEAVES_OAK.id()) continue;
                Blocks.LAYER_LEAVES_OAK.getLogic().accumulate(world, x, y + q, z);
                break;
            }
        }
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        WindProvider wind;
        float windIntensity;
        if (world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().hasFallingLeaves && rand.nextInt((int)(40.0f + 200.0f * (1.0f - (windIntensity = (wind = world.getWorldType().getWindManager()).getWindIntensity(world, x, y, z))))) == 0) {
            world.spawnParticle("fallingleaf", x, (double)y - (double)0.1f, z, 0.0, 0.0, 0.0, 0);
        }
    }
}

