/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobAge {
    public static final int YEAR_LENGTH_DAYS = 56;
    @NotNull
    private final Mob mob;
    private final int maxAge;
    @Nullable
    private AABB boundingBox = null;
    private int ageDays;
    private long ticksInDay = 0L;
    private long lastTicked = -1L;

    @NotNull
    public static MobAge newRandom(@NotNull Mob mob, int maxAge, int minRandomAge, int maxRandomAge) {
        return new MobAge(mob, maxAge, minRandomAge + mob.random.nextInt(maxRandomAge - minRandomAge));
    }

    public MobAge(@NotNull Mob mob, int maxAge, int age) {
        this.mob = mob;
        this.maxAge = maxAge;
        this.ageDays = age;
    }

    public int getAge() {
        return this.ageDays;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setAge(int age) {
        this.ageDays = age;
    }

    public boolean isAtMaxAge() {
        return this.getAge() >= this.getMaxAge();
    }

    public float getAgeScale() {
        return 0.6f + (float)this.getAge() / (float)this.getMaxAge() * 0.6f;
    }

    public void tick(@NotNull World world) {
        AABB mobBB;
        if (this.boundingBox == null && (mobBB = this.mob.getBb()) != null) {
            this.boundingBox = mobBB.copyPermanent();
        }
        if (this.isAtMaxAge()) {
            return;
        }
        int currentAge = this.getAge();
        if (this.lastTicked == -1L) {
            this.lastTicked = world.getWorldTime();
        }
        if (world.getWorldTime() < this.lastTicked) {
            this.lastTicked = world.getWorldTime();
        }
        this.ticksInDay += world.getWorldTime() - this.lastTicked;
        this.lastTicked = world.getWorldTime();
        while (this.ticksInDay >= 24000L) {
            ++this.ageDays;
            this.ticksInDay -= 24000L;
        }
        if (currentAge < this.maxAge && this.boundingBox != null) {
            float size = this.getAgeScale();
            this.mob.getBb().minX = this.boundingBox.minX * (double)size;
            this.mob.getBb().minY = this.boundingBox.minY * (double)size;
            this.mob.getBb().minZ = this.boundingBox.minZ * (double)size;
            this.mob.getBb().maxX = this.boundingBox.maxX * (double)size;
            this.mob.getBb().maxY = this.boundingBox.maxY * (double)size;
            this.mob.getBb().maxZ = this.boundingBox.maxZ * (double)size;
        }
    }

    public void writeTag(@NotNull CompoundTag mobTag) {
        @NotNull CompoundTag ageTag = new CompoundTag();
        ageTag.putInt("age", this.ageDays);
        ageTag.putLong("ticksInDay", this.ticksInDay);
        ageTag.putLong("lastTicked", this.lastTicked);
        mobTag.put("age", ageTag);
    }

    public void readTag(@NotNull CompoundTag mobTag) {
        @Nullable CompoundTag ageTag = mobTag.getCompoundOrDefault("age", null);
        if (ageTag == null) {
            this.ageDays = this.maxAge;
            this.ticksInDay = 0L;
            this.lastTicked = -1L;
        } else {
            this.ageDays = ageTag.getInteger("age");
            this.ticksInDay = ageTag.getLong("ticksInDay");
            this.lastTicked = ageTag.getLong("lastTicked");
        }
    }
}

