/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.overworld.b173;

import java.util.Random;
import net.minecraft.core.block.BlockLogicSand;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.WorldFeatureCactus;
import net.minecraft.core.world.generate.feature.WorldFeatureClay;
import net.minecraft.core.world.generate.feature.WorldFeatureDeadBush;
import net.minecraft.core.world.generate.feature.WorldFeatureDungeon;
import net.minecraft.core.world.generate.feature.WorldFeatureFlowers;
import net.minecraft.core.world.generate.feature.WorldFeatureLake;
import net.minecraft.core.world.generate.feature.WorldFeatureLiquid;
import net.minecraft.core.world.generate.feature.WorldFeatureOre;
import net.minecraft.core.world.generate.feature.WorldFeaturePumpkin;
import net.minecraft.core.world.generate.feature.WorldFeatureSugarCane;
import net.minecraft.core.world.generate.feature.WorldFeatureTallGrass;
import net.minecraft.core.world.noise.PerlinNoise;
import org.jetbrains.annotations.NotNull;

public class ChunkDecoratorOverworldB173
implements ChunkDecorator {
    @NotNull
    private final World world;
    @NotNull
    private final PerlinNoise forestNoise;

    public ChunkDecoratorOverworldB173(@NotNull World world) {
        this.world = world;
        this.forestNoise = new PerlinNoise(world.getRandomSeed(), 8, 82);
    }

    @Override
    public void decorate(Chunk chunk) {
        int fz;
        int fy;
        int fx;
        int i;
        int fz2;
        int fy2;
        int fx2;
        int i2;
        int fz3;
        int fy3;
        int fx3;
        int fz4;
        int fy4;
        int fx4;
        int i3;
        int fz5;
        int fy5;
        int fx5;
        this.world.scheduledUpdatesAreImmediate = true;
        BlockLogicSand.fallInstantly = true;
        int x = chunk.xPosition;
        int z = chunk.zPosition;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        int wx = x * 16;
        int wz = z * 16;
        @NotNull Biome biome = this.world.getBlockBiome(wx, 0, wz);
        @NotNull Random rand = new Random(this.world.getRandomSeed());
        long rx = rand.nextLong() / 2L * 2L + 1L;
        long rz = rand.nextLong() / 2L * 2L + 1L;
        rand.setSeed(rx * (long)x + rz * (long)z ^ this.world.getRandomSeed());
        if (rand.nextInt(4) == 0) {
            fx5 = wx + rand.nextInt(16) + 8;
            fy5 = rand.nextInt(rangeY);
            fz5 = wz + rand.nextInt(16) + 8;
            new WorldFeatureLake(Blocks.FLUID_WATER_STILL.id()).place(this.world, rand, fx5, fy5, fz5);
        }
        if (rand.nextInt(8) == 0) {
            fx5 = wx + rand.nextInt(16) + 8;
            fy5 = rand.nextInt(rangeY);
            fz5 = wz + rand.nextInt(16) + 8;
            if (fy5 < rangeY / 2 || rand.nextInt(10) == 0) {
                new WorldFeatureLake(Blocks.FLUID_LAVA_STILL.id()).place(this.world, rand, fx5, fy5, fz5);
            }
        }
        for (i3 = 0; i3 < 8; ++i3) {
            fx4 = wx + rand.nextInt(16) + 8;
            fy4 = rand.nextInt(rangeY);
            fz4 = wz + rand.nextInt(16) + 8;
            new WorldFeatureDungeon(Blocks.COBBLE_STONE.id(), Blocks.COBBLE_STONE_MOSSY.id(), null).place(this.world, rand, fx4, fy4, fz4);
        }
        for (i3 = 0; i3 < 10; ++i3) {
            fx4 = wx + rand.nextInt(16);
            fy4 = rand.nextInt(rangeY);
            fz4 = wz + rand.nextInt(16);
            new WorldFeatureClay(32).place(this.world, rand, fx4, fy4, fz4);
        }
        for (i3 = 0; i3 < 20; ++i3) {
            fx4 = wx + rand.nextInt(16);
            fy4 = rand.nextInt(rangeY);
            fz4 = wz + rand.nextInt(16);
            new WorldFeatureOre(Blocks.DIRT.id(), 32).place(this.world, rand, fx4, fy4, fz4);
        }
        for (i3 = 0; i3 < 10; ++i3) {
            fx4 = wx + rand.nextInt(16);
            fy4 = rand.nextInt(rangeY);
            fz4 = wz + rand.nextInt(16);
            new WorldFeatureOre(Blocks.GRAVEL.id(), 32).place(this.world, rand, fx4, fy4, fz4);
        }
        for (i3 = 0; i3 < 20; ++i3) {
            fx4 = wx + rand.nextInt(16);
            fy4 = rand.nextInt(rangeY);
            fz4 = wz + rand.nextInt(16);
            new WorldFeatureOre(Blocks.ORE_COAL_STONE.id(), 16).place(this.world, rand, fx4, fy4, fz4);
        }
        for (i3 = 0; i3 < 20; ++i3) {
            fx4 = wx + rand.nextInt(16);
            fy4 = rand.nextInt(rangeY / 2);
            fz4 = wz + rand.nextInt(16);
            new WorldFeatureOre(Blocks.ORE_IRON_STONE.id(), 8).place(this.world, rand, fx4, fy4, fz4);
        }
        for (i3 = 0; i3 < 2; ++i3) {
            fx4 = wx + rand.nextInt(16);
            fy4 = rand.nextInt(rangeY / 4);
            fz4 = wz + rand.nextInt(16);
            new WorldFeatureOre(Blocks.ORE_GOLD_STONE.id(), 8).place(this.world, rand, fx4, fy4, fz4);
        }
        for (i3 = 0; i3 < 8; ++i3) {
            fx4 = wx + rand.nextInt(16);
            fy4 = rand.nextInt(rangeY / 8);
            fz4 = wz + rand.nextInt(16);
            new WorldFeatureOre(Blocks.ORE_REDSTONE_STONE.id(), 7).place(this.world, rand, fx4, fy4, fz4);
        }
        for (i3 = 0; i3 < 1; ++i3) {
            fx4 = wx + rand.nextInt(16);
            fy4 = rand.nextInt(rangeY / 16);
            fz4 = wz + rand.nextInt(16);
            new WorldFeatureOre(Blocks.ORE_DIAMOND_STONE.id(), 7).place(this.world, rand, fx4, fy4, fz4);
        }
        for (i3 = 0; i3 < 1; ++i3) {
            fx4 = wx + rand.nextInt(16);
            fy4 = rand.nextInt(rangeY / 16) + rand.nextInt(rangeY / 16);
            fz4 = wz + rand.nextInt(16);
            new WorldFeatureOre(Blocks.ORE_LAPIS_STONE.id(), 6).place(this.world, rand, fx4, fy4, fz4);
        }
        double forestNoiseScale = 0.5;
        int forestNoiseValue = (int)((this.forestNoise.get((double)wx * 0.5, (double)wz * 0.5) / 8.0 + rand.nextDouble() * 4.0 + 4.0) / 3.0);
        int numTrees = 0;
        if (rand.nextInt(10) == 0) {
            ++numTrees;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_FOREST) {
            numTrees += forestNoiseValue + 5;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_RAINFOREST) {
            numTrees += forestNoiseValue + 5;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_SEASONAL_FOREST) {
            numTrees += forestNoiseValue + 2;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_TAIGA) {
            numTrees += forestNoiseValue + 5;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_DESERT) {
            numTrees -= 20;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_TUNDRA) {
            numTrees -= 20;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_PLAINS) {
            numTrees -= 20;
        }
        for (int i4 = 0; i4 < numTrees; ++i4) {
            int fx6 = wx + rand.nextInt(16) + 8;
            int fz6 = wz + rand.nextInt(16) + 8;
            @NotNull WorldFeature feature = biome.getRandomWorldGenForTrees(rand);
            feature.init(1.0, 1.0, 1.0);
            biome.getRandomWorldGenForTrees(rand).place(this.world, rand, fx6, this.world.getHeightValue(fx6, fz6), fz6);
        }
        int numYellowFlowers = 0;
        if (biome == Biomes.OVERWORLD_LEGACY_FOREST) {
            numYellowFlowers += 2;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_SEASONAL_FOREST) {
            numYellowFlowers += 4;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_TAIGA) {
            numYellowFlowers += 2;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_PLAINS) {
            numYellowFlowers += 3;
        }
        for (int i5 = 0; i5 < numYellowFlowers; ++i5) {
            int fx7 = wx + rand.nextInt(16) + 8;
            int fy6 = rand.nextInt(rangeY);
            int fz7 = wz + rand.nextInt(16) + 8;
            new WorldFeatureFlowers(Blocks.FLOWER_YELLOW.id(), 64, false).place(this.world, rand, fx7, fy6, fz7);
        }
        int numPlants = 0;
        if (biome == Biomes.OVERWORLD_LEGACY_FOREST) {
            numPlants += 2;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_RAINFOREST) {
            numPlants += 10;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_SEASONAL_FOREST) {
            numPlants += 2;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_TAIGA) {
            ++numPlants;
        }
        if (biome == Biomes.OVERWORLD_LEGACY_PLAINS) {
            numPlants += 10;
        }
        for (int i6 = 0; i6 < numPlants; ++i6) {
            int plantBlockId = Blocks.TALLGRASS.id();
            if (biome == Biomes.OVERWORLD_LEGACY_RAINFOREST && rand.nextInt(3) != 0) {
                plantBlockId = Blocks.TALLGRASS_FERN.id();
            }
            fx3 = wx + rand.nextInt(16) + 8;
            fy3 = rand.nextInt(rangeY);
            fz3 = wz + rand.nextInt(16) + 8;
            new WorldFeatureTallGrass(plantBlockId).place(this.world, rand, fx3, fy3, fz3);
        }
        int numDeadBushes = 0;
        if (biome == Biomes.OVERWORLD_LEGACY_DESERT) {
            numDeadBushes += 2;
        }
        for (i2 = 0; i2 < numDeadBushes; ++i2) {
            fx3 = wx + rand.nextInt(16) + 8;
            fy3 = rand.nextInt(rangeY);
            fz3 = wz + rand.nextInt(16) + 8;
            new WorldFeatureDeadBush(Blocks.DEADBUSH.id()).place(this.world, rand, fx3, fy3, fz3);
        }
        if (rand.nextInt(2) == 0) {
            fx2 = wx + rand.nextInt(16) + 8;
            fy2 = rand.nextInt(rangeY);
            fz2 = wz + rand.nextInt(16) + 8;
            new WorldFeatureFlowers(Blocks.FLOWER_RED.id(), 64, false).place(this.world, rand, fx2, fy2, fz2);
        }
        if (rand.nextInt(4) == 0) {
            fx2 = wx + rand.nextInt(16) + 8;
            fy2 = rand.nextInt(rangeY);
            fz2 = wz + rand.nextInt(16) + 8;
            new WorldFeatureFlowers(Blocks.MUSHROOM_BROWN.id(), 64, false).place(this.world, rand, fx2, fy2, fz2);
        }
        if (rand.nextInt(8) == 0) {
            fx2 = wx + rand.nextInt(16) + 8;
            fy2 = rand.nextInt(rangeY);
            fz2 = wz + rand.nextInt(16) + 8;
            new WorldFeatureFlowers(Blocks.MUSHROOM_RED.id(), 64, false).place(this.world, rand, fx2, fy2, fz2);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            fx3 = wx + rand.nextInt(16) + 8;
            fy3 = rand.nextInt(rangeY);
            fz3 = wz + rand.nextInt(16) + 8;
            new WorldFeatureSugarCane().place(this.world, rand, fx3, fy3, fz3);
        }
        if (rand.nextInt(32) == 0) {
            fx2 = wx + rand.nextInt(16) + 8;
            fy2 = rand.nextInt(rangeY);
            fz2 = wz + rand.nextInt(16) + 8;
            new WorldFeaturePumpkin().place(this.world, rand, fx2, fy2, fz2);
        }
        int numCacti = 0;
        if (biome == Biomes.OVERWORLD_LEGACY_DESERT) {
            numCacti += 10;
        }
        for (i = 0; i < numCacti; ++i) {
            fx = wx + rand.nextInt(16) + 8;
            fy = rand.nextInt(rangeY);
            fz = wz + rand.nextInt(16) + 8;
            new WorldFeatureCactus().place(this.world, rand, fx, fy, fz);
        }
        for (i = 0; i < 50; ++i) {
            fx = wx + rand.nextInt(16) + 8;
            fy = rand.nextInt(rangeY);
            fz = wz + rand.nextInt(16) + 8;
            new WorldFeatureLiquid(Blocks.FLUID_WATER_FLOWING.id()).place(this.world, rand, fx, fy, fz);
        }
        for (i = 0; i < 20; ++i) {
            fx = wx + rand.nextInt(16) + 8;
            fy = rand.nextInt(rangeY);
            fz = wz + rand.nextInt(16) + 8;
            new WorldFeatureLiquid(Blocks.FLUID_LAVA_FLOWING.id()).place(this.world, rand, fx, fy, fz);
        }
        int oceanY = this.world.getWorldType().getOceanY();
        for (int xx = x + 8; xx < x + 8 + 16; ++xx) {
            for (int zz = z + 8; zz < z + 8 + 16; ++zz) {
                int yy = this.world.getHeightValue(xx, zz);
                Biome localBiome = this.world.getBlockBiome(xx, yy, zz);
                if (localBiome.hasSurfaceSnow() && yy > 0 && yy < this.world.getHeightBlocks() && this.world.isAirBlock(xx, yy, zz) && this.world.getBlockMaterial(xx, yy - 1, zz).blocksMotion()) {
                    this.world.setBlockWithNotify(xx, yy, zz, Blocks.LAYER_SNOW.id());
                }
                if (!localBiome.hasSurfaceSnow() || this.world.getBlockId(xx, oceanY - 1, zz) != Blocks.FLUID_WATER_STILL.id() && this.world.getBlockId(xx, oceanY - 1, zz) != Blocks.FLUID_WATER_FLOWING.id()) continue;
                this.world.setBlockWithNotify(xx, oceanY - 1, zz, Blocks.ICE.id());
            }
        }
        BlockLogicSand.fallInstantly = false;
        this.world.scheduledUpdatesAreImmediate = false;
    }
}

