/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicEdible;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLogicCake
extends BlockLogicEdible {
    public BlockLogicCake(Block<?> block) {
        super(block, 6, () -> Items.FOOD_CAKE);
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        float f = 0.0625f;
        float f1 = (float)(1 + l * 2) / 16.0f;
        float f2 = 0.5f;
        return AABB.getTemporaryBB(f1, 0.0, f, 1.0f - f, f2, 1.0f - f);
    }

    @Override
    public int getHealAmount(@NotNull World world, int x, int y, int z) {
        return 3;
    }
}

