/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicEdible;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLogicPiePumpkin
extends BlockLogicEdible {
    public BlockLogicPiePumpkin(Block<?> block) {
        super(block, 4, () -> Items.FOOD_PUMPKIN_PIE);
    }

    @Override
    public int getHealAmount(@NotNull World world, int x, int y, int z) {
        return 5;
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        float f = 0.0625f;
        float xMin = l >= 2 ? 0.5f : f;
        float zMin = l >= 3 ? 0.5f : f;
        float f2 = 0.375f;
        return AABB.getTemporaryBB(xMin, 0.0, zMin, 1.0f - f, f2, 1.0f - f);
    }
}

