/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.season;

import java.util.List;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.config.season.SeasonConfigCycle;
import net.minecraft.core.world.config.season.SeasonConfigSingle;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.SeasonManagerCycle;
import net.minecraft.core.world.season.SeasonManagerSingle;

public abstract class SeasonManager {
    protected final World world;

    public static SeasonManager fromConfig(World world, SeasonConfig config) {
        if (config instanceof SeasonConfigSingle) {
            return new SeasonManagerSingle(world, (SeasonConfigSingle)config);
        }
        if (config instanceof SeasonConfigCycle) {
            return new SeasonManagerCycle(world, (SeasonConfigCycle)config);
        }
        return null;
    }

    public SeasonManager(World world) {
        this.world = world;
    }

    public abstract List<Season> getSeasons();

    public abstract Season getPreviousSeason();

    public abstract Season getCurrentSeason();

    public abstract Season getNextSeason();

    public abstract float getSeasonProgress();

    public abstract int getDayInSeason();

    public float getSeasonModifier() {
        float progress = this.getSeasonProgress();
        progress = MathHelper.cos((progress * 2.0f - 1.0f) * (float)Math.PI);
        progress = (progress + 1.0f) / 2.0f;
        return progress;
    }
}

