/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.block.BlockLogicBed;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.SpawnListEntry;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.MobCategory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.ChunkCoordinate;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.ChunkPosition;
import net.minecraft.core.world.config.spawning.SpawnerConfig;
import net.minecraft.core.world.pathfinder.Node;
import net.minecraft.core.world.pathfinder.Path;
import net.minecraft.core.world.pathfinder.PathFinder;
import org.slf4j.Logger;

public final class SpawnerMobs {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<ChunkCoordinate> eligibleChunksForSpawning = new HashSet<ChunkCoordinate>();
    private static final Class<?>[] nightSpawnEntities = new Class[]{MobSpider.class, MobZombie.class, MobSkeleton.class, MobZombieArmored.class};

    private static ChunkPosition getRandomSpawningPointInChunk(World world, int chunkX, int chunkZ) {
        int newX = chunkX * 16 + world.rand.nextInt(16);
        int newY = world.rand.nextInt(world.getHeightBlocks());
        int newZ = chunkZ * 16 + world.rand.nextInt(16);
        return new ChunkPosition(newX, newY, newZ);
    }

    public static int performSpawning(World world, SpawnerConfig spawnerConfig) {
        if (!spawnerConfig.canHostileSpawn(world) && !spawnerConfig.canPassiveSpawn(world)) {
            return 0;
        }
        eligibleChunksForSpawning.clear();
        for (Player player : world.players) {
            int playerChunkX = MathHelper.floor(player.x / 16.0);
            int playerChunkZ = MathHelper.floor(player.z / 16.0);
            int spawnRadius = 8;
            for (int dx = -8; dx <= 8; ++dx) {
                for (int dz = -8; dz <= 8; ++dz) {
                    if (!world.isChunkLoaded(dx + playerChunkX, dz + playerChunkZ)) continue;
                    eligibleChunksForSpawning.add(new ChunkCoordinate(dx + playerChunkX, dz + playerChunkZ));
                }
            }
        }
        int totalSpawned = 0;
        ChunkCoordinates spawnPoint = world.getSpawnPoint();
        ChunkCoordinate[] spawnChunks = new ChunkCoordinate[9];
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                spawnChunks[x * 3 + z] = new ChunkCoordinate((spawnPoint.x & 0xF) + (x - 1), (spawnPoint.z & 0xF) + (z - 1));
            }
        }
        for (MobCategory creatureType : MobCategory.values()) {
            if (creatureType.isPeaceful() && !spawnerConfig.canPassiveSpawn(world) || !creatureType.isPeaceful() && !spawnerConfig.canHostileSpawn(world) || world.countEntities(creatureType.getBaseClass()) > creatureType.getMaxCreaturesPerChunk() * eligibleChunksForSpawning.size() / 256) continue;
            block8: for (ChunkCoordinate chunk : eligibleChunksForSpawning) {
                boolean checkSpawnDist = false;
                for (ChunkCoordinate c : spawnChunks) {
                    if (!c.equals(chunk)) continue;
                    checkSpawnDist = true;
                    break;
                }
                if (!world.isChunkLoaded(chunk.x, chunk.z)) continue;
                int blockX = chunk.x * 16;
                int blockZ = chunk.z * 16;
                Biome biome = world.getBlockBiome(blockX, world.getHeightBlocks() - 1, blockZ);
                List<SpawnListEntry> spawnableList = biome.getSpawnableList(creatureType);
                if (spawnableList == null || spawnableList.isEmpty()) continue;
                int totalSpawnRarity = 0;
                for (SpawnListEntry spawnListEntry : spawnableList) {
                    totalSpawnRarity += spawnListEntry.spawnFrequency;
                }
                int calculatedSpawnChance = world.rand.nextInt(totalSpawnRarity);
                SpawnListEntry spawnListEntry = spawnableList.get(0);
                for (SpawnListEntry listEntry : spawnableList) {
                    if ((calculatedSpawnChance -= listEntry.spawnFrequency) >= 0) continue;
                    spawnListEntry = listEntry;
                    break;
                }
                if (!spawnerConfig.canMobSpawn(EntityDispatcher.idForClass(spawnListEntry.entityClass))) continue;
                ChunkPosition chunkPosition = SpawnerMobs.getRandomSpawningPointInChunk(world, chunk.x, chunk.z);
                int x = chunkPosition.x;
                int y = chunkPosition.y;
                int z = chunkPosition.z;
                if (world.isBlockNormalCube(x, y, z) || world.getBlockMaterial(x, y, z) != creatureType.getSpawnMaterial()) continue;
                int countSpawned = 0;
                int range = 6;
                for (int i = 0; i < 3; ++i) {
                    int ix = x;
                    int iy = y;
                    int iz = z;
                    for (int spawnAttempt = 0; spawnAttempt < 4; ++spawnAttempt) {
                        Mob mobToSpawn;
                        double spawnDistanceZ;
                        double spawnDistanceY;
                        double spawnDistanceX;
                        double spawnDistanceSquared;
                        double dz;
                        double dy;
                        double dx;
                        if (!world.isBlockLoaded(ix += world.rand.nextInt(6) - world.rand.nextInt(6), iy += world.rand.nextInt(2) - world.rand.nextInt(2), iz += world.rand.nextInt(6) - world.rand.nextInt(6)) || !SpawnerMobs.canCreatureTypeSpawnAtLocation(creatureType, world, ix, iy, iz) || world.getClosestPlayer(dx = (double)ix + 0.5, dy = (double)iy, dz = (double)iz + 0.5, 24.0) != null || checkSpawnDist && (spawnDistanceSquared = (spawnDistanceX = dx - (double)spawnPoint.x) * spawnDistanceX + (spawnDistanceY = dy - (double)spawnPoint.y) * spawnDistanceY + (spawnDistanceZ = dz - (double)spawnPoint.z) * spawnDistanceZ) < 576.0) continue;
                        try {
                            mobToSpawn = (Mob)spawnListEntry.entityClass.getConstructor(World.class).newInstance(world);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error spawning entity class '{}' class missing default constructor for World! Skipping spawn attempt!", (Object)spawnListEntry.entityClass.getSimpleName(), (Object)e);
                            return totalSpawned;
                        }
                        mobToSpawn.moveTo(dx, dy, dz, world.rand.nextFloat() * 360.0f, 0.0f);
                        if (!mobToSpawn.canSpawnHere()) continue;
                        if (countSpawned >= mobToSpawn.getMaxSpawnedInChunk()) continue block8;
                        ++countSpawned;
                        mobToSpawn.spawnInit();
                        world.entityJoinedWorld(mobToSpawn);
                    }
                }
                totalSpawned += countSpawned;
            }
        }
        return totalSpawned;
    }

    private static boolean canCreatureTypeSpawnAtLocation(MobCategory mobCategory, World world, int x, int y, int z) {
        if (mobCategory.getSpawnMaterial() == Material.water) {
            return world.getBlockMaterial(x, y, z).isLiquid() && !world.isBlockNormalCube(x, y + 1, z);
        }
        return world.isBlockNormalCube(x, y - 1, z) && !world.isBlockNormalCube(x, y, z) && !world.getBlockMaterial(x, y, z).isLiquid();
    }

    public static boolean isUnsafeToSleep(World world, Player player) {
        if (!world.getGameRuleValue(GameRules.DO_NIGHTMARES).booleanValue()) {
            return false;
        }
        if (player.isPlayerSleeping()) {
            return false;
        }
        if (player.getGamemode().isPlayerInvulnerable()) {
            return false;
        }
        Class<?>[] entityClasses = nightSpawnEntities;
        if (entityClasses != null && entityClasses.length != 0) {
            boolean willSpawnEntity = false;
            PathFinder pathFinder = new PathFinder(world);
            for (int i = 0; i < 20 && !willSpawnEntity; ++i) {
                boolean isCollisionFree;
                Path pathEntity;
                Mob entity;
                int spawnY;
                int x = MathHelper.floor(player.x) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int z = MathHelper.floor(player.z) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int y = MathHelper.floor(player.y) + world.rand.nextInt(16) - world.rand.nextInt(16);
                for (spawnY = y = MathHelper.clamp(y, 1, world.getHeightBlocks()); spawnY > 2 && !world.isBlockNormalCube(x, spawnY - 1, z); --spawnY) {
                }
                while (!SpawnerMobs.canCreatureTypeSpawnAtLocation(MobCategory.monster, world, x, spawnY, z) && spawnY < y + 16 && spawnY < world.getHeightBlocks()) {
                    ++spawnY;
                }
                if (spawnY >= y + 16) continue;
                float entityX = (float)x + 0.5f;
                float entityY = spawnY;
                float entityZ = (float)z + 0.5f;
                Class<?> eClass = entityClasses[world.rand.nextInt(entityClasses.length)];
                try {
                    entity = (Mob)eClass.getConstructor(World.class).newInstance(world);
                }
                catch (Exception e) {
                    LOGGER.error("Exception instancing class '{}'!", (Object)eClass.getSimpleName(), (Object)e);
                    return false;
                }
                entity.moveTo(entityX, entityY, entityZ, world.rand.nextFloat() * 360.0f, 0.0f);
                if (!entity.canSpawnHere() || (pathEntity = pathFinder.findPath(entity, player, 32.0f)) == null || pathEntity.length <= 1) continue;
                Node pathPoint = pathEntity.last();
                boolean bl = isCollisionFree = world.checkBlockCollisionBetweenPoints(Vec3.getTempVec3(player.x, player.y + 1.5, player.z), Vec3.getTempVec3(pathPoint.x, (float)pathPoint.y + 1.5f, pathPoint.z)) == null;
                if (!(Math.abs((double)((float)pathPoint.x + 0.5f) - player.x) < 1.5) || !(Math.abs((double)((float)pathPoint.z + 0.5f) - player.z) < 1.5) || !(Math.abs((double)((float)pathPoint.y + 0.5f) - player.y) < 1.5) || !isCollisionFree) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean performSleepSpawning(World world, List<Player> list) {
        if (!world.getGameRuleValue(GameRules.DO_NIGHTMARES).booleanValue()) {
            return false;
        }
        boolean spawnedEntity = false;
        PathFinder pathFinder = new PathFinder(world);
        for (Player player : list) {
            Class<?>[] entityClasses;
            if (!player.isPlayerSleeping() || player.getGamemode().isPlayerInvulnerable() || (entityClasses = nightSpawnEntities) == null || entityClasses.length == 0) continue;
            boolean spawnedEntityForPlayer = false;
            for (int i = 0; i < 20 && !spawnedEntityForPlayer; ++i) {
                boolean isCollisionFree;
                Path pathEntity;
                Mob entity;
                int spawnY;
                int x = MathHelper.floor(player.x) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int z = MathHelper.floor(player.z) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int y = MathHelper.floor(player.y) + world.rand.nextInt(16) - world.rand.nextInt(16);
                for (spawnY = y = MathHelper.clamp(y, 1, world.getHeightBlocks()); spawnY > 2 && !world.isBlockNormalCube(x, spawnY - 1, z); --spawnY) {
                }
                while (!SpawnerMobs.canCreatureTypeSpawnAtLocation(MobCategory.monster, world, x, spawnY, z) && spawnY < y + 16 && spawnY < world.getHeightBlocks()) {
                    ++spawnY;
                }
                if (spawnY >= y + 16) continue;
                float entityX = (float)x + 0.5f;
                float entityY = spawnY;
                float entityZ = (float)z + 0.5f;
                Class<?> eClass = entityClasses[world.rand.nextInt(entityClasses.length)];
                try {
                    entity = (Mob)eClass.getConstructor(World.class).newInstance(world);
                }
                catch (Exception e) {
                    LOGGER.error("Exception instancing class '{}'!", (Object)eClass.getSimpleName(), (Object)e);
                    return spawnedEntity;
                }
                entity.moveTo(entityX, entityY, entityZ, world.rand.nextFloat() * 360.0f, 0.0f);
                if (!entity.canSpawnHere() || (pathEntity = pathFinder.findPath(entity, player, 32.0f)) == null || pathEntity.length <= 1) continue;
                Node pathPoint = pathEntity.last();
                boolean bl = isCollisionFree = world.checkBlockCollisionBetweenPoints(Vec3.getTempVec3(player.x, player.y + 1.5, player.z), Vec3.getTempVec3(pathPoint.x, (float)pathPoint.y + 1.5f, pathPoint.z)) == null;
                if (!(Math.abs((double)((float)pathPoint.x + 0.5f) - player.x) < 1.5) || !(Math.abs((double)((float)pathPoint.z + 0.5f) - player.z) < 1.5) || !(Math.abs((double)((float)pathPoint.y + 0.5f) - player.y) < 1.5) || !isCollisionFree) continue;
                ChunkCoordinates pos = BlockLogicBed.getNearestEmptyChunkCoordinates(world, MathHelper.floor(player.x), MathHelper.floor(player.y), MathHelper.floor(player.z), 1);
                if (pos == null) {
                    pos = new ChunkCoordinates(x, spawnY + 1, z);
                }
                entity.moveTo((float)pos.x + 0.5f, pos.y, (float)pos.z + 0.5f, 0.0f, 0.0f);
                entity.spawnInit();
                world.entityJoinedWorld(entity);
                player.wakeUpPlayer(true, false);
                world.playBlockEvent(null, 2001, (int)player.x, (int)player.y - 1, (int)player.z, world.getBlockId((int)player.x, (int)player.y - 1, (int)player.z));
                entity.playLivingSound();
                spawnedEntity = true;
                spawnedEntityForPlayer = true;
            }
        }
        return spawnedEntity;
    }
}

