/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import com.mojang.logging.LogQueues;
import com.mojang.logging.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.minecraft.core.net.ICommandListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.gui.GuiStatsComponent;
import net.minecraft.server.player.PlayerListBox;
import org.slf4j.Logger;

public class ServerGui
extends JComponent
implements ICommandListener {
    public static Logger LOGGER = LogUtils.getLogger();
    public static Font MONOSPACED = new Font("Monospaced", 0, 12);
    private final MinecraftServer mcServer;
    private Thread logAppenderThread;

    public static void initGui(final MinecraftServer mcServer) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LOGGER.warn("Could not set UI Look and Feel!", exception);
        }
        ServerGui servergui = new ServerGui(mcServer);
        JFrame jframe = new JFrame("Minecraft server");
        jframe.add(servergui);
        jframe.pack();
        jframe.setLocationRelativeTo(null);
        jframe.setVisible(true);
        jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                mcServer.stopServer();
                mcServer.initiateShutdown();
                while (!mcServer.serverStopped) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.error("Interrupt in window close!", ex);
                    }
                }
                System.exit(0);
            }
        });
        servergui.start();
    }

    public ServerGui(MinecraftServer mcServer) {
        this.mcServer = mcServer;
        this.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.getLogComponent(), "Center");
            this.add((Component)this.getStatsComponent(), "West");
        }
        catch (Exception exception) {
            LOGGER.error("Error constructing ServerGUI!", exception);
        }
    }

    private JComponent getStatsComponent() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)new GuiStatsComponent(), "North");
        jpanel.add((Component)this.getPlayerListComponent(), "Center");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Stats"));
        return jpanel;
    }

    private JComponent getPlayerListComponent() {
        PlayerListBox playerlistbox = new PlayerListBox(this.mcServer);
        JScrollPane jscrollpane = new JScrollPane(playerlistbox, 22, 30);
        jscrollpane.setBorder(new TitledBorder(new EtchedBorder(), "Players"));
        return jscrollpane;
    }

    private JComponent getLogComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 30);
        jTextArea.setEditable(false);
        jTextArea.setFont(MONOSPACED);
        JTextField jTextField = new JTextField();
        jTextField.addActionListener(e -> {
            String s = jTextField.getText().trim();
            if (!s.isEmpty()) {
                this.mcServer.addCommand(s, this);
            }
            jTextField.setText("");
        });
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jTextField, "South");
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Log and chat"));
        this.logAppenderThread = new Thread(() -> {
            String logEvent;
            while ((logEvent = LogQueues.getNextLogEvent("ServerGuiConsole")) != null) {
                this.print(jTextArea, jScrollPane, logEvent);
            }
        });
        this.logAppenderThread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        this.logAppenderThread.setDaemon(true);
        return jPanel;
    }

    public void print(JTextArea textArea, JScrollPane scrollPane, String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.print(textArea, scrollPane, message));
            return;
        }
        Document document = textArea.getDocument();
        JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
        boolean scrollMax = false;
        if (scrollPane.getViewport().getView() == textArea) {
            scrollMax = (double)scrollBar.getValue() + scrollBar.getSize().getHeight() + (double)(MONOSPACED.getSize() * 4) > (double)scrollBar.getMaximum();
        }
        try {
            document.insertString(document.getLength(), message, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (scrollMax) {
            scrollBar.setValue(Integer.MAX_VALUE);
        }
    }

    @Override
    public void logInfo(String s) {
        LOGGER.info(s);
    }

    @Override
    public String getUsername() {
        return "CONSOLE";
    }

    public void start() {
        this.logAppenderThread.start();
    }

    static MinecraftServer getMinecraftServer(ServerGui servergui) {
        return servergui.mcServer;
    }

    public static class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Logger logger;

        public DefaultUncaughtExceptionHandler(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable t) {
            this.logger.error("Caught previously unhandled exception :", t);
        }
    }
}

