/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import java.util.Objects;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.IArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.util.helper.DamageType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IArmorWearing<T extends IArmorShape> {
    @Nullable
    public ItemStack getItemInArmorSlot(@NotNull T var1);

    public void setItemInArmorSlot(@NotNull T var1, @Nullable ItemStack var2);

    public int getNumArmorSlots();

    @Nullable
    public T getArmorSlotByIndex(int var1);

    default public float getTotalProtectionAmount(@NotNull DamageType damageType) {
        float protectionPercentage = 0.0f;
        for (int i = 0; i < this.getNumArmorSlots(); ++i) {
            IArmorItem armor;
            ArmorMaterial material;
            @NotNull IArmorShape armorSlot = (IArmorShape)Objects.requireNonNull(this.getArmorSlotByIndex(i));
            @Nullable ItemStack armorItem = this.getItemInArmorSlot(armorSlot);
            if (armorItem == null || !(armorItem.getItem() instanceof IArmorItem) || (material = (armor = (IArmorItem)((Object)armorItem.getItem())).getArmorMaterial()) == null) continue;
            protectionPercentage += material.getProtection(damageType) * armor.getArmorPieceProtectionPercentage();
        }
        return protectionPercentage;
    }

    default public void damageArmor(int damage, @NotNull T armorSlot) {
        IArmorItem armor;
        ArmorMaterial material;
        @Nullable ItemStack armorItem = this.getItemInArmorSlot(armorSlot);
        if (armorItem != null && armorItem.getItem() instanceof IArmorItem && (material = (armor = (IArmorItem)((Object)armorItem.getItem())).getArmorMaterial()) != null) {
            if (this instanceof Entity) {
                armorItem.damageItem(damage, (Entity)((Object)this));
            } else {
                armorItem.damageItem(damage, null);
            }
            if (armorItem.stackSize <= 0) {
                this.setItemInArmorSlot(armorSlot, null);
            }
        }
    }

    default public void damageArmor(int damage) {
        for (int i = 0; i < this.getNumArmorSlots(); ++i) {
            @NotNull IArmorShape armorSlot = (IArmorShape)Objects.requireNonNull(this.getArmorSlotByIndex(i));
            this.damageArmor(damage, armorSlot);
        }
    }

    default public boolean canItemGoInArmorSlot(@NotNull T slot, @Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        return this.canItemGoInArmorSlot(slot, item.getItem());
    }

    default public boolean canItemGoInArmorSlot(@NotNull T slot, @Nullable IItemConvertible item) {
        if (item == null || item.asItem() == null) {
            return false;
        }
        @NotNull Item realItem = item.asItem();
        if (!(realItem instanceof IArmorItem)) {
            return false;
        }
        return ((IArmorItem)((Object)realItem)).getArmorShape() == slot;
    }
}

