/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.menu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuInventory;
import net.minecraft.core.player.inventory.slot.SlotCreative;
import net.minecraft.core.util.helper.DyeColor;

public class MenuInventoryCreative
extends MenuInventory {
    public int page = 0;
    public int maxPage;
    protected int creativeSlotsStart;
    protected List<ItemStack> searchedItems = new ArrayList<ItemStack>();
    public String searchText = "";
    public static List<ItemStack> creativeItems = new ArrayList<ItemStack>();

    public MenuInventoryCreative(ContainerInventory inventoryplayer) {
        this(inventoryplayer, true);
    }

    public MenuInventoryCreative(ContainerInventory inventoryplayer, boolean isNotClientSide) {
        super(inventoryplayer, isNotClientSide);
        this.creativeSlotsStart = this.slots.size();
        for (int i = 0; i < 36; ++i) {
            int x = i % 6;
            int y = i / 6;
            this.addSlot(new SlotCreative(this.creativeSlotsStart + i, 184 + x * 18, 30 + y * 18, creativeItems.get(i)));
        }
        this.searchPage("");
    }

    public void setInventoryStatus(int page, String searchText) {
        if (this.page != page) {
            this.page = page;
            this.updatePage();
        }
        if (!this.searchText.equals(searchText)) {
            this.searchText = searchText;
            this.searchPage(searchText);
        }
    }

    public void lastPage() {
        if (this.page == 0) {
            return;
        }
        --this.page;
        this.updatePage();
    }

    public void nextPage() {
        if (this.page == this.maxPage) {
            return;
        }
        ++this.page;
        this.updatePage();
    }

    public void searchPage(String search) {
        this.searchText = search;
        this.searchedItems.clear();
        this.page = 0;
        I18n t = I18n.getInstance();
        int itemsCount = creativeItems.size();
        for (int i = 0; i < itemsCount; ++i) {
            if (!t.translateKey(creativeItems.get(i).getItemKey() + ".name").toLowerCase().contains(search.toLowerCase())) continue;
            this.searchedItems.add(creativeItems.get(i));
        }
        this.updatePage();
    }

    protected void updatePage() {
        this.maxPage = this.searchedItems.size() / 36;
        if (this.searchedItems.size() % 36 == 0) {
            --this.maxPage;
        }
        if (this.maxPage == -1) {
            this.maxPage = 0;
        }
        for (int i = 0; i < 36; ++i) {
            ((SlotCreative)this.slots.get((int)(this.creativeSlotsStart + i))).item = i + this.page * 36 >= this.searchedItems.size() ? null : this.searchedItems.get(i + this.page * 36);
        }
        this.inventory.player.updateCreativeInventory(this.page, this.searchText);
    }

    public String getSearchText() {
        return this.searchText;
    }

    @Override
    public int getHotbarSlotId(int number) {
        return number + 8 + 27;
    }

    static {
        for (Block<?> block : Blocks.blocksList) {
            if (block == null || block.hasTag(BlockTags.NOT_IN_CREATIVE_MENU)) continue;
            if (Block.hasLogicClass(block, IPainted.class)) {
                IPainted painted = (IPainted)block.getLogic();
                for (DyeColor color : DyeColor.values()) {
                    creativeItems.add(new ItemStack(block, 1, painted.toMetadata(color)));
                }
                continue;
            }
            creativeItems.add(new ItemStack(block));
        }
        for (int i = Blocks.blocksList.length; i < Item.itemsList.length; ++i) {
            Item item = Item.itemsList[i];
            if (item == null || item.hasTag(ItemTags.NOT_IN_CREATIVE_MENU)) continue;
            if (item == Items.PAINTBRUSH) {
                creativeItems.add(new ItemStack(item, 1, Items.PAINTBRUSH.getMaxDamage()));
                continue;
            }
            if (item == Items.COAL) {
                creativeItems.add(new ItemStack(item, 1, 0));
                creativeItems.add(new ItemStack(item, 1, 1));
                continue;
            }
            if (item == Items.DYE || item == Items.DOOR_OAK_PAINTED || item == Items.SIGN_PAINTED) {
                for (DyeColor color : DyeColor.values()) {
                    creativeItems.add(new ItemStack(item, 1, color.itemMeta));
                }
                continue;
            }
            creativeItems.add(new ItemStack(item));
        }
    }
}

