/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicMesh;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityMeshGold;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMeshGold
extends BlockLogicMesh {
    public BlockLogicMeshGold(Block<?> block) {
        super(block);
        block.withEntity(TileEntityMeshGold::new);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        TileEntityMeshGold meshGold = (TileEntityMeshGold)world.getTileEntity(x, y, z);
        ItemStack heldItem = player.getHeldItem();
        boolean flag = meshGold.setFilterItem(player, heldItem);
        world.notifyBlocksOfNeighborChange(x, y, z, this.id());
        if (heldItem != null && heldItem.stackSize <= 0) {
            player.inventory.setItem(player.inventory.getCurrentItemIndex(), null);
        }
        return flag;
    }

    @Override
    public boolean collidesWithEntity(Entity entity, World world, int x, int y, int z) {
        if (entity instanceof EntityItem) {
            TileEntityMeshGold mesh = (TileEntityMeshGold)world.getTileEntity(x, y, z);
            if (mesh.filterItem == null) {
                return true;
            }
            ItemStack entityStack = ((EntityItem)entity).item;
            return !this.stacksAreSame(entityStack, mesh.filterItem);
        }
        return true;
    }

    @Override
    public boolean isEquivalent(@NotNull World world, int thisX, int thisY, int thisZ, int otherX, int otherY, int otherZ) {
        if (super.isEquivalent(world, thisX, thisY, thisZ, otherX, otherY, otherZ)) {
            TileEntity thisEntity = world.getTileEntity(thisX, thisY, thisZ);
            TileEntity otherEntity = world.getTileEntity(otherX, otherY, otherZ);
            if (thisEntity instanceof TileEntityMeshGold && otherEntity instanceof TileEntityMeshGold) {
                TileEntityMeshGold thisMesh = (TileEntityMeshGold)thisEntity;
                TileEntityMeshGold otherMesh = (TileEntityMeshGold)otherEntity;
                return this.stacksAreSame(thisMesh.filterItem, otherMesh.filterItem);
            }
        }
        return false;
    }

    public boolean stacksAreSame(@Nullable ItemStack a, @Nullable ItemStack b) {
        return a == b || a != null && b != null && a.itemID == b.itemID && a.getMetadata() == b.getMetadata() && a.getData().equals(b.getData());
    }
}

