/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.current.util;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.current.util.BlockPos;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockState {
    public static final BlockState AIR = new BlockState(null, 0){

        @Override
        public int getBlockId() {
            return 0;
        }

        @Override
        public boolean is(Block<?> block) {
            return false;
        }

        @Override
        public BlockState set(int metadata) {
            return this;
        }

        @Override
        public boolean isAir() {
            return true;
        }

        @Override
        public boolean isConductor() {
            return false;
        }

        @Override
        public boolean isSignalSource() {
            return false;
        }

        @Override
        public boolean hasSignal(World world, BlockPos pos, Direction dir) {
            return false;
        }

        @Override
        public boolean hasDirectSignal(World world, BlockPos pos, Direction dir) {
            return false;
        }

        @Override
        public boolean canSurvive(World world, BlockPos pos) {
            return true;
        }

        @Override
        public void dropItems(World world, BlockPos pos) {
        }

        @Override
        public void neighborChanged(World world, BlockPos pos, Block<?> fromBlock) {
        }
    };
    private final Block<?> block;
    private final int metadata;

    public BlockState(int blockId, int metadata) {
        this(Blocks.getBlock(blockId), metadata);
    }

    public BlockState(Block<?> block, int metadata) {
        this.block = block;
        this.metadata = metadata;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockState) {
            BlockState state = (BlockState)obj;
            return state.block == this.block && state.metadata == this.metadata;
        }
        return false;
    }

    public int getBlockId() {
        return this.block.id();
    }

    public Block<?> getBlock() {
        return this.block;
    }

    public boolean is(Block<?> block) {
        return this.block == block;
    }

    public int get() {
        return this.metadata;
    }

    public BlockState set(int metadata) {
        return new BlockState(this.block, metadata);
    }

    public boolean isAir() {
        return this == AIR;
    }

    public boolean isConductor() {
        return this.block.getMaterial().isSolidBlocking() && this.block.isSolidRender();
    }

    public boolean isSignalSource() {
        return this.block.isSignalSource();
    }

    public boolean hasSignal(World world, BlockPos pos, Direction dir) {
        return this.block.getSignal(world, pos.x, pos.y, pos.z, dir.getSide());
    }

    public boolean hasDirectSignal(World world, BlockPos pos, Direction dir) {
        return this.block.getDirectSignal(world, pos.x, pos.y, pos.z, dir.getSide());
    }

    public boolean canSurvive(World world, BlockPos pos) {
        Block<?> block = world.getBlock(pos.x, pos.y, pos.z);
        if (block == Blocks.WIRE_REDSTONE) {
            return Blocks.WIRE_REDSTONE.getLogic().isSupported(world, pos.x, pos.y, pos.z, Side.BOTTOM);
        }
        Block<?> underBlock = world.getBlock(pos.x, pos.y - 1, pos.z);
        return (block == null || block.getMaterial().isReplaceable()) && underBlock != null && underBlock.isCubeShaped();
    }

    public void dropItems(World world, BlockPos pos) {
        this.block.dropBlockWithCause(world, EnumDropCause.WORLD, pos.x, pos.y, pos.z, 0, null, null);
    }

    public void neighborChanged(World world, BlockPos pos, Block<?> neighborBlock) {
        this.block.onNeighborBlockChange(world, pos.x, pos.y, pos.z, neighborBlock.id());
    }
}

