/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IComplexItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketMapData;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.saveddata.maps.ItemMapSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMap
extends Item
implements IComplexItem {
    private static final Int2ObjectMap<Int2IntMap> blockCounts = new Int2ObjectOpenHashMap<Int2IntMap>();

    protected ItemMap(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
    }

    @NotNull
    public static ItemMapSavedData getOrCreateSavedData(short meta, byte scale, World world) {
        String s = String.format("map_%s_scale_%s", meta, scale);
        ItemMapSavedData mapData = (ItemMapSavedData)world.getSavedData(ItemMapSavedData.class, s);
        if (mapData == null) {
            if (scale == 3 && (mapData = (ItemMapSavedData)world.getSavedData(ItemMapSavedData.class, String.format("map_%s", meta))) != null) {
                for (byte i = 0; i <= 4; i = (byte)(i + 1)) {
                    String _s = String.format("map_%s_scale_%s", meta, i);
                    if (i == 3) {
                        world.setSavedData(_s, mapData);
                        continue;
                    }
                    ItemMapSavedData d = new ItemMapSavedData(_s);
                    d.x = mapData.x;
                    d.z = mapData.z;
                    d.scale = i;
                    d.dimension = mapData.dimension;
                    d.setDirty();
                    world.setSavedData(_s, d);
                }
                return mapData;
            }
            mapData = new ItemMapSavedData(s);
            mapData.x = world.getLevelData().getSpawnX();
            mapData.z = world.getLevelData().getSpawnZ();
            mapData.scale = scale;
            mapData.dimension = (byte)world.dimension.id;
            mapData.setDirty();
            world.setSavedData(s, mapData);
        }
        return mapData;
    }

    public static boolean hasInitialized(ItemStack stack) {
        return stack.getData().getBooleanOrDefault("initialized", false);
    }

    @Nullable
    public ItemMapSavedData getOrCreateSavedData(ItemStack stack, World world) {
        if (!ItemMap.hasInitialized(stack)) {
            return null;
        }
        byte scale = this.getScale(stack);
        int meta = stack.getMetadata();
        String s = String.format("map_%s_scale_%s", meta, scale);
        ItemMapSavedData mapData = (ItemMapSavedData)world.getSavedData(ItemMapSavedData.class, s);
        if (mapData == null) {
            if (scale == 3 && (mapData = (ItemMapSavedData)world.getSavedData(ItemMapSavedData.class, String.format("map_%s", meta))) != null) {
                for (byte i = 0; i <= 4; i = (byte)(i + 1)) {
                    String _s = String.format("map_%s_scale_%s", meta, i);
                    if (i == 3) {
                        world.setSavedData(_s, mapData);
                        continue;
                    }
                    ItemMapSavedData d = new ItemMapSavedData(_s);
                    d.x = mapData.x;
                    d.z = mapData.z;
                    d.scale = i;
                    d.dimension = mapData.dimension;
                    d.setDirty();
                    world.setSavedData(_s, d);
                }
                return mapData;
            }
            mapData = new ItemMapSavedData(s);
            mapData.x = world.getLevelData().getSpawnX();
            mapData.z = world.getLevelData().getSpawnZ();
            mapData.scale = scale;
            mapData.dimension = (byte)world.dimension.id;
            mapData.setDirty();
            world.setSavedData(s, mapData);
        }
        return mapData;
    }

    @Override
    @Nullable
    public ItemStack onUseItem(@NotNull ItemStack itemstack, @NotNull World world, @NotNull Player entityplayer) {
        if (!ItemMap.hasInitialized(itemstack)) {
            this.initMap(itemstack, world, entityplayer);
        } else {
            this.setScale(itemstack, (byte)(this.getScale(itemstack) + (entityplayer.isSneaking() ? 1 : -1)));
        }
        return itemstack;
    }

    @Override
    public boolean onUseItemOnBlock(@NotNull ItemStack itemstack, @Nullable Player player, @NotNull World world, int blockX, int blockY, int blockZ, @NotNull Side side, double xPlaced, double yPlaced) {
        if (world.getBlockId(blockX, blockY, blockZ) == Blocks.FLAG.id() && ItemMap.hasInitialized(itemstack)) {
            for (byte scale = 0; scale <= 4; scale = (byte)(scale + 1)) {
                TileEntityFlag flag;
                ItemMapSavedData mapData = ItemMap.getOrCreateSavedData((short)itemstack.getMetadata(), scale, world);
                if (mapData.createNewWaypoint(flag = (TileEntityFlag)world.getTileEntity(blockX, blockY, blockZ)) != ItemMapSavedData.FlagError.FULL) continue;
                player.sendTranslatedChatMessage("flag.full");
                break;
            }
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    public void update(World world, Entity entity, ItemMapSavedData data) {
        if (world.dimension.id != data.dimension) {
            return;
        }
        int mapWidth = 128;
        int mapHeight = 128;
        int blocksPerPixel = 1 << data.scale;
        int mapCenterX = data.x;
        int mapCenterZ = data.z;
        int entityOnMapX = MathHelper.floor(entity.x - (double)mapCenterX) / blocksPerPixel + 64;
        int entityOnMapZ = MathHelper.floor(entity.z - (double)mapCenterZ) / blocksPerPixel + 64;
        int discoverRadius = 128 / blocksPerPixel;
        if (world.worldType.hasCeiling()) {
            discoverRadius /= 2;
        }
        ++data.tick;
        for (int x = entityOnMapX - discoverRadius + 1; x < entityOnMapX + discoverRadius; ++x) {
            if ((x & 0xF) != (data.tick & 0xF)) continue;
            int minZ = 255;
            int maxZ = 0;
            double previousPixelHeight = 0.0;
            boolean previousChunkLoaded = false;
            for (int z = entityOnMapZ - discoverRadius - 1; z < entityOnMapZ + discoverRadius; ++z) {
                byte finalColor;
                byte currentColor;
                if (x < 0 || z < -1 || x >= 128 || z >= 128) continue;
                int distX = x - entityOnMapX;
                int distZ = z - entityOnMapZ;
                boolean flag = distX * distX + distZ * distZ > (discoverRadius - 2) * (discoverRadius - 2);
                int blockX = (mapCenterX / blocksPerPixel + x - 64) * blocksPerPixel;
                int blockZ = (mapCenterZ / blocksPerPixel + z - 64) * blocksPerPixel;
                if (!world.isBlockLoaded(blockX, world.getHeightBlocks() / 2, blockZ)) {
                    previousChunkLoaded = false;
                    continue;
                }
                blockCounts.clear();
                int blockInChunkX = blockX & 0xF;
                int blockInChunkZ = blockZ & 0xF;
                int waterDepth = 0;
                double pixelHeight = 0.0;
                if (world.worldType.hasCeiling()) {
                    int rand = blockX + blockZ * 231871;
                    if (((rand = rand * rand * 31287121 + rand * 11) >> 20 & 1) == 0) {
                        if (!blockCounts.containsKey(Blocks.DIRT.id())) {
                            blockCounts.put(Blocks.DIRT.id(), (Int2IntMap)new Int2IntOpenHashMap());
                        }
                        ((Int2IntMap)blockCounts.get(Blocks.DIRT.id())).put(-1, ((Int2IntMap)blockCounts.get(Blocks.DIRT.id())).getOrDefault(-1, 0) + 10);
                    } else {
                        if (!blockCounts.containsKey(Blocks.STONE.id())) {
                            blockCounts.put(Blocks.STONE.id(), (Int2IntMap)new Int2IntOpenHashMap());
                        }
                        ((Int2IntMap)blockCounts.get(Blocks.STONE.id())).put(-1, ((Int2IntMap)blockCounts.get(Blocks.STONE.id())).getOrDefault(-1, 0) + 10);
                    }
                    pixelHeight = 100.0;
                } else {
                    Chunk chunk = world.getChunkFromBlockCoords(blockX, blockZ);
                    for (int _x = 0; _x < blocksPerPixel; ++_x) {
                        for (int _z = 0; _z < blocksPerPixel; ++_z) {
                            int height = chunk.getHeightValue(_x + blockInChunkX, _z + blockInChunkZ);
                            int id = 0;
                            if (height > 0) {
                                boolean runLoop;
                                do {
                                    runLoop = false;
                                    id = chunk.getBlockID(_x + blockInChunkX, height, _z + blockInChunkZ);
                                    if (id > 0 && (height <= 0 || Blocks.blocksList[id].getMaterialColor() != MaterialColor.none)) continue;
                                    runLoop = true;
                                    --height;
                                } while (runLoop);
                                if (Blocks.blocksList[id].getMaterial() == Material.water) {
                                    int _y = height;
                                    int _blockID = chunk.getBlockID(_x + blockInChunkX, _y--, _z + blockInChunkZ);
                                    ++waterDepth;
                                    while (_y > 0 && _blockID > 0 && Blocks.blocksList[_blockID].getMaterial() == Material.water) {
                                        _blockID = chunk.getBlockID(_x + blockInChunkX, _y--, _z + blockInChunkZ);
                                        ++waterDepth;
                                    }
                                }
                            }
                            pixelHeight += (double)height / (double)(blocksPerPixel * blocksPerPixel);
                            int meta = chunk.getBlockMetadata(_x + blockInChunkX, height, _z + blockInChunkZ);
                            if (!blockCounts.containsKey(id)) {
                                blockCounts.put(id, (Int2IntMap)new Int2IntOpenHashMap());
                            }
                            ((Int2IntMap)blockCounts.get(id)).put(-1, ((Int2IntMap)blockCounts.get(id)).getOrDefault(-1, 0) + 1);
                            ((Int2IntMap)blockCounts.get(id)).put(meta, ((Int2IntMap)blockCounts.get(id)).getOrDefault(meta, 0) + 1);
                        }
                    }
                }
                waterDepth /= blocksPerPixel * blocksPerPixel;
                int max = 0;
                int id = 0;
                for (Int2ObjectMap.Entry e : blockCounts.int2ObjectEntrySet()) {
                    if (((Int2IntMap)e.getValue()).getOrDefault(-1, -1) <= max) continue;
                    id = e.getIntKey();
                    max = ((Int2IntMap)e.getValue()).get(-1);
                }
                int meta = 0;
                max = 0;
                for (int i = 0; i < 256; ++i) {
                    if (((Int2IntMap)blockCounts.get(id)).getOrDefault(i, -1) <= max) continue;
                    meta = i;
                    max = ((Int2IntMap)blockCounts.get(id)).get(i);
                }
                double heightDifference = (pixelHeight - previousPixelHeight) * 4.0 / (double)(blocksPerPixel + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int brightness = 1;
                if (heightDifference > 0.6) {
                    brightness = 2;
                }
                if (heightDifference < -0.6) {
                    brightness = 0;
                }
                int colorIndex = 0;
                if (id > 0) {
                    MaterialColor mapcolor = Blocks.blocksList[id].getMaterialColor();
                    if (mapcolor == MaterialColor.water) {
                        double d3 = (double)waterDepth * 0.1 + (double)(x + z & 1) * 0.2;
                        brightness = 1;
                        if (d3 < 0.5) {
                            brightness = 2;
                        }
                        if (d3 > 0.9) {
                            brightness = 0;
                        }
                    }
                    colorIndex = MaterialColor.getColorIndexFromBlock(Blocks.blocksList[id], meta);
                }
                previousPixelHeight = pixelHeight;
                if (!previousChunkLoaded) {
                    previousChunkLoaded = true;
                    continue;
                }
                if (z < 0 || distX * distX + distZ * distZ >= discoverRadius * discoverRadius || flag && (x + z & 1) == 0 || (currentColor = data.colors[x + z * 128]) == (finalColor = (byte)(colorIndex << 2 | brightness & 3))) continue;
                if (minZ > z) {
                    minZ = z;
                }
                if (maxZ < z) {
                    maxZ = z;
                }
                data.colors[x + z * 128] = finalColor;
            }
            if (minZ > maxZ) continue;
            data.setDirty(x, minZ, maxZ);
        }
    }

    @Override
    public void inventoryTick(ItemStack itemstack, World world, Entity entity, int slotId, boolean isHeld) {
        ItemMapSavedData mapData;
        if (world.isClientSide) {
            return;
        }
        if (ItemMap.hasInitialized(itemstack)) {
            byte mapScale = this.getScale(itemstack);
            for (byte scale = 0; scale <= 4; scale = (byte)(scale + 1)) {
                ItemMapSavedData mapData2 = ItemMap.getOrCreateSavedData((short)itemstack.getMetadata(), scale, world);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (scale == mapScale) {
                        mapData2.tickCarriedBy(player, itemstack);
                    }
                    mapData2.tickForWaypoints(player, itemstack);
                }
                if (scale != mapScale || !isHeld) continue;
                this.update(world, entity, mapData2);
            }
        }
        if ((mapData = this.getOrCreateSavedData(itemstack, world)) != null) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                mapData.tickCarriedBy(player, itemstack);
            }
            if (isHeld) {
                this.update(world, entity, mapData);
            }
        }
    }

    public void initMap(ItemStack itemstack, World world, Player player) {
        boolean insert;
        boolean bl = insert = itemstack.stackSize > 1;
        if (insert) {
            --itemstack.stackSize;
            itemstack = itemstack.copy();
            itemstack.stackSize = 1;
        }
        itemstack.setMetadata(world.getUniqueDataId("map"));
        for (int i = 0; i <= 4; i = (int)((byte)(i + 1))) {
            String s = "map_" + itemstack.getMetadata() + "_scale_" + i;
            ItemMapSavedData mapdata = new ItemMapSavedData(s);
            world.setSavedData(s, mapdata);
            mapdata.x = MathHelper.floor(player.x) >> 4 << 4;
            mapdata.z = MathHelper.floor(player.z) >> 4 << 4;
            mapdata.scale = (byte)i;
            mapdata.dimension = (byte)world.dimension.id;
            mapdata.setDirty();
        }
        itemstack.getData().putBoolean("initialized", true);
        if (insert) {
            player.inventory.insertItem(itemstack, true);
        }
    }

    @Override
    public Packet sendPacketData(ItemStack itemstack, World world, Player player) {
        ItemMapSavedData itemMapSavedData = this.getOrCreateSavedData(itemstack, world);
        if (itemMapSavedData != null) {
            byte[] mapDataBytes = itemMapSavedData.getMapDataBytes(itemstack, world, player);
            if (mapDataBytes == null) {
                return null;
            }
            return new PacketMapData((short)Items.MAP.id, (short)itemstack.getMetadata(), this.getScale(itemstack), mapDataBytes, itemMapSavedData.mapWaypoints);
        }
        return null;
    }

    @Override
    public String getTranslatedName(ItemStack itemstack) {
        if (!ItemMap.hasInitialized(itemstack)) {
            return I18n.getInstance().translateKey(itemstack.getItemKey() + ".blank.name");
        }
        return super.getTranslatedName(itemstack) + " #" + itemstack.getMetadata();
    }

    private byte getScale(ItemStack itemStack) {
        return itemStack.getData().getByteOrDefault("scale", (byte)3);
    }

    private void setScale(ItemStack itemStack, byte scale) {
        byte currentScale = this.getScale(itemStack);
        while (scale < 0) {
            scale = (byte)(scale + 5);
        }
        if (currentScale == scale) {
            return;
        }
        scale = (byte)(scale % 5);
        itemStack.getData().putByte("scale", scale);
    }
}

