/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.piston.BlockLogicPistonBase;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLogicPistonHead
extends BlockLogic {
    public static final int MASK_DIRECTION = 7;
    public static final int MASK_TYPE = 248;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_STICKY = 1;
    public static final int TYPE_STEEL = 2;
    private final double headThickness;
    private final double shaftThickness;

    public BlockLogicPistonHead(Block<?> block, double headThickness, double shaftThickness) {
        super(block, Material.piston);
        block.withHardness(0.5f);
        this.headThickness = headThickness;
        this.shaftThickness = shaftThickness;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        int data2;
        int z2;
        int y2;
        super.onBlockRemoved(world, x, y, z, data);
        Direction direction = BlockLogicPistonHead.getDirectionFromMeta(data);
        if (direction == Direction.NONE) {
            return;
        }
        Direction orientation = direction.getOpposite();
        int x2 = x + orientation.getOffsetX();
        Block<?> block = world.getBlock(x2, y2 = y + orientation.getOffsetY(), z2 = z + orientation.getOffsetZ());
        if (block != null && block.getLogic() instanceof BlockLogicPistonBase && BlockLogicPistonBase.isPowered(data2 = world.getBlockMetadata(x2, y2, z2))) {
            block.dropBlockWithCause(world, EnumDropCause.PROPER_TOOL, x2, y2, z2, data2, null, null);
            world.setBlockWithNotify(x2, y2, z2, 0);
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        int meta = world.getBlockMetadata(x, y, z);
        return BlockLogicPistonHead.getDirectionFromMeta(meta).getSide() == side ? FullSupport.INSTANCE : PartialSupport.INSTANCE;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, Side side) {
        return false;
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbList) {
        switch (BlockLogicPistonHead.getDirectionFromMeta(world.getBlockMetadata(x, y, z))) {
            case DOWN: {
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0, 0.0, 1.0, this.headThickness, 1.0).move(x, y, z), aabbList);
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.5 - this.shaftThickness / 2.0, this.headThickness, 0.5 - this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0, 1.0 + this.headThickness, 0.5 + this.shaftThickness / 2.0).move(x, y, z), aabbList);
                break;
            }
            case UP: {
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 1.0 - this.headThickness, 0.0, 1.0, 1.0, 1.0).move(x, y, z), aabbList);
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.5 - this.shaftThickness / 2.0, -this.headThickness, 0.5 - this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0, 1.0 - this.headThickness, 0.5 + this.shaftThickness / 2.0).move(x, y, z), aabbList);
                break;
            }
            case NORTH: {
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, this.headThickness).move(x, y, z), aabbList);
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.5 - this.shaftThickness / 2.0, 0.5 - this.shaftThickness / 2.0, this.headThickness, 0.5 + this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0, 1.0 + this.headThickness).move(x, y, z), aabbList);
                break;
            }
            case SOUTH: {
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0, 1.0).move(x, y, z), aabbList);
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.5 - this.shaftThickness / 2.0, 0.5 - this.shaftThickness / 2.0, -this.headThickness, 0.5 + this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0, 1.0 - this.headThickness).move(x, y, z), aabbList);
                break;
            }
            case WEST: {
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0, 0.0, this.headThickness, 1.0, 1.0).move(x, y, z), aabbList);
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(this.headThickness, 0.5 - this.shaftThickness / 2.0, 0.5 - this.shaftThickness / 2.0, 1.0 + this.headThickness, 0.5 + this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0).move(x, y, z), aabbList);
                break;
            }
            case EAST: {
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(1.0 - this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0).move(x, y, z), aabbList);
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(-this.headThickness, 0.5 - this.shaftThickness / 2.0, 0.5 - this.shaftThickness / 2.0, 1.0 - this.headThickness, 0.5 + this.shaftThickness / 2.0, 0.5 + this.shaftThickness / 2.0).move(x, y, z), aabbList);
            }
        }
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        switch (BlockLogicPistonHead.getDirectionFromMeta(l)) {
            case DOWN: {
                return AABB.fromPool(0.0, 0.0, 0.0, 1.0, this.headThickness, 1.0);
            }
            case UP: {
                return AABB.fromPool(0.0, 1.0 - this.headThickness, 0.0, 1.0, 1.0, 1.0);
            }
            case NORTH: {
                return AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, this.headThickness);
            }
            case SOUTH: {
                return AABB.fromPool(0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0, 1.0);
            }
            case WEST: {
                return AABB.fromPool(0.0, 0.0, 0.0, this.headThickness, 1.0, 1.0);
            }
            case EAST: {
                return AABB.fromPool(1.0 - this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        return super.getBlockBoundsFromState(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        Direction direction = BlockLogicPistonHead.getDirectionFromMeta(world.getBlockMetadata(x, y, z));
        if (direction == Direction.NONE) {
            return;
        }
        Block<?> block = world.getBlock(x - direction.getOffsetX(), y - direction.getOffsetY(), z - direction.getOffsetZ());
        if (block != null && block.getLogic() instanceof BlockLogicPistonBase) {
            block.onNeighborBlockChange(world, x - direction.getOffsetX(), y - direction.getOffsetY(), z - direction.getOffsetZ(), blockId);
        } else {
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public int getPistonPushReaction(World world, int x, int y, int z) {
        return 2;
    }

    public static Direction getDirectionFromMeta(int meta) {
        return Direction.getDirectionById(meta & 7);
    }

    public static int getPistonType(int data) {
        return (data & 0xFF & 0xF8) >> 3;
    }

    public static int setPistonType(int type, int data) {
        return (data & 0xFFFFFF07 | type << 3) & 0xFF;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK) {
            switch (BlockLogicPistonHead.getPistonType(meta)) {
                case 0: {
                    return new ItemStack[]{new ItemStack(Blocks.PISTON_BASE)};
                }
                case 1: {
                    return new ItemStack[]{new ItemStack(Blocks.PISTON_BASE_STICKY)};
                }
                case 2: {
                    return new ItemStack[]{new ItemStack(Blocks.PISTON_BASE_STEEL)};
                }
            }
        }
        return null;
    }
}

