/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.linalg;

import java.util.Objects;
import net.minecraft.core.util.linalg.Vector3;
import net.minecraft.core.util.pool.ObjectPool;
import net.minecraft.core.util.pool.Poolable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Vector4
implements Poolable<Vector4> {
    @NotNull
    private static final ObjectPool<Vector4> POOL = new ObjectPool<Vector4>(Vector4::new);
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double w = 0.0;

    @NotNull
    public static Vector4 fromPool(double x, double y, double z, double w) {
        return POOL.get().set(x, y, z, w);
    }

    @NotNull
    public static Vector4 unitX() {
        return Vector4.fromPool(1.0, 0.0, 0.0, 0.0);
    }

    @NotNull
    public static Vector4 unitY() {
        return Vector4.fromPool(0.0, 1.0, 0.0, 0.0);
    }

    @NotNull
    public static Vector4 unitZ() {
        return Vector4.fromPool(0.0, 0.0, 1.0, 0.0);
    }

    @NotNull
    public static Vector4 unitW() {
        return Vector4.fromPool(0.0, 0.0, 0.0, 1.0);
    }

    private Vector4() {
    }

    @Override
    @NotNull
    public ObjectPool<Vector4> getPool() {
        return POOL;
    }

    @Override
    public void set(@NotNull Vector4 other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.w = other.w;
    }

    @NotNull
    public Vector4 set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    @NotNull
    public Vector3 truncate() {
        return Vector3.fromPool(this.x, this.y, this.z);
    }

    @NotNull
    public Vector4 neg() {
        return ((Vector4)this.copyPooled()).negInPlace();
    }

    @NotNull
    public Vector4 negInPlace() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    @NotNull
    public Vector4 add(@NotNull Vector4 other) {
        return ((Vector4)this.copyPooled()).addInPlace(other);
    }

    @NotNull
    public Vector4 addInPlace(@NotNull Vector4 other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        this.w += other.w;
        return this;
    }

    @NotNull
    public Vector4 sub(@NotNull Vector4 other) {
        return ((Vector4)this.copyPooled()).subInPlace(other);
    }

    @NotNull
    public Vector4 subInPlace(@NotNull Vector4 other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
        this.w -= other.w;
        return this;
    }

    public double @NotNull [] asArray() {
        return new double[]{this.x, this.y, this.z, this.w};
    }

    @NotNull
    public Vector4 mult(double value) {
        return ((Vector4)this.copyPooled()).multInPlace(value);
    }

    @NotNull
    public Vector4 multInPlace(double value) {
        this.x *= value;
        this.y *= value;
        this.z *= value;
        this.w *= value;
        return this;
    }

    @NotNull
    public Vector4 div(double value) {
        return ((Vector4)this.copyPooled()).divInPlace(value);
    }

    @NotNull
    public Vector4 divInPlace(double value) {
        this.x /= value;
        this.y /= value;
        this.z /= value;
        this.w /= value;
        return this;
    }

    public double dot(@NotNull Vector4 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public double squaredMagnitude() {
        return this.dot(this);
    }

    public double magnitude() {
        return Math.sqrt(this.squaredMagnitude());
    }

    public double angle(@NotNull Vector4 other) {
        return Math.acos(this.dot(other)) / (this.magnitude() * other.magnitude());
    }

    @NotNull
    public Vector4 normalize() {
        return this.normalize(1.0);
    }

    @NotNull
    public Vector4 normalize(double magnitude) {
        return this.mult(magnitude / this.magnitude());
    }

    public double squaredDistance(@NotNull Vector4 other) {
        return other.sub(this).squaredMagnitude();
    }

    public double distance(@NotNull Vector4 other) {
        return Math.sqrt(this.squaredDistance(other));
    }

    @NotNull
    public Vector3 lerp(@NotNull Vector3 other, double amount) {
        return Vector3.fromPool(this.x + (other.x - this.x) * amount, this.y + (other.y - this.y) * amount, this.z + (other.z - this.z) * amount);
    }

    @Nullable
    public Vector4 clipX(@NotNull Vector4 other, double x) {
        @NotNull Vector4 delta = other.sub(this);
        if (delta.x * delta.x < 1.0E-7) {
            return null;
        }
        double percentage = x - this.x - delta.x;
        if (percentage < 0.0 || percentage > 1.0) {
            return null;
        }
        return Vector4.fromPool(this.x + delta.x * percentage, this.y + delta.y * percentage, this.z + delta.z * percentage, this.w + delta.w * percentage);
    }

    @Nullable
    public Vector4 clipY(@NotNull Vector4 other, double y) {
        @NotNull Vector4 delta = other.sub(this);
        if (delta.y * delta.y < 1.0E-7) {
            return null;
        }
        double percentage = y - this.y - delta.y;
        if (percentage < 0.0 || percentage > 1.0) {
            return null;
        }
        return Vector4.fromPool(this.x + delta.x * percentage, this.y + delta.y * percentage, this.z + delta.z * percentage, this.w + delta.w * percentage);
    }

    @Nullable
    public Vector4 clipZ(@NotNull Vector4 other, double z) {
        @NotNull Vector4 delta = other.sub(this);
        if (delta.z * delta.z < 1.0E-7) {
            return null;
        }
        double percentage = z - this.z - delta.z;
        if (percentage < 0.0 || percentage > 1.0) {
            return null;
        }
        return Vector4.fromPool(this.x + delta.x * percentage, this.y + delta.y * percentage, this.z + delta.z * percentage, this.w + delta.w * percentage);
    }

    @Nullable
    public Vector4 clipW(@NotNull Vector4 other, double w) {
        @NotNull Vector4 delta = other.sub(this);
        if (delta.w * delta.w < 1.0E-7) {
            return null;
        }
        double percentage = w - this.w - delta.w;
        if (percentage < 0.0 || percentage > 1.0) {
            return null;
        }
        return Vector4.fromPool(this.x + delta.x * percentage, this.y + delta.y * percentage, this.z + delta.z * percentage, this.w + delta.w * percentage);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vector4) {
            @NotNull Vector4 other = (Vector4)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z && this.w == other.w;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        return "[ " + this.x + ", " + this.y + ", " + this.z + ", " + this.w + " ]";
    }
}

