/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlowerStackable;
import net.minecraft.core.block.BlockLogicOverlayPebbles;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;
import org.jetbrains.annotations.NotNull;

public class WorldFeaturePebbles
extends WorldFeature {
    private final int blockId;
    private final int count;
    private final boolean varyStackSize;

    @MethodParametersAnnotation(names={"blockId", "count", "varyStackSize"})
    public WorldFeaturePebbles(int blockId, int count, boolean varyStackSize) {
        this.blockId = blockId;
        this.count = count;
        this.varyStackSize = varyStackSize;
    }

    @Override
    public boolean place(@NotNull World world, @NotNull Random random, int x, int y, int z) {
        for (int i = 0; i < this.count; ++i) {
            int metadata;
            int zz;
            int yy;
            int xx = x + random.nextInt(8) - random.nextInt(8);
            if (!world.isAirBlock(xx, yy = y + random.nextInt(4) - random.nextInt(4), zz = z + random.nextInt(8) - random.nextInt(8)) || !BlockLogicOverlayPebbles.canSpawnOn(world.getBlock(xx, yy - 1, zz))) continue;
            if (Block.hasLogicClass(Blocks.getBlock(this.blockId), BlockLogicOverlayPebbles.class)) {
                int stackSize = this.varyStackSize ? WorldFeaturePebbles.getStackSize(random) : 0;
                metadata = BlockLogicFlowerStackable.setStackCount(0, stackSize);
            } else {
                metadata = 0;
            }
            world.setBlockAndMetadata(xx, yy, zz, this.blockId, metadata);
        }
        return true;
    }

    private static int getStackSize(@NotNull Random random) {
        int odds = random.nextInt(18);
        if (odds < 8) {
            return 0;
        }
        if (odds < 14) {
            return 1;
        }
        return 2;
    }
}

