/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pathfinder;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.pathfinder.Node;

public class Path {
    private final Node[] nodes;
    public final int length;
    private int index;

    public Path(Node[] nodes) {
        this.nodes = nodes;
        this.length = nodes.length;
    }

    public void next() {
        ++this.index;
    }

    public boolean isDone() {
        return this.index >= this.nodes.length;
    }

    public Node last() {
        if (this.length > 0) {
            return this.nodes[this.length - 1];
        }
        return null;
    }

    public Vec3 getPos(Entity entity) {
        double x = (double)this.nodes[this.index].x + (double)((int)(entity.bbWidth + 2.0f)) * 0.5;
        double y = this.nodes[this.index].y;
        double z = (double)this.nodes[this.index].z + (double)((int)(entity.bbWidth + 2.0f)) * 0.5;
        return Vec3.fromPool(x, y, z);
    }
}

