/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class FluidWater
implements Fluid {
    @Override
    public int tickDelay() {
        return 5;
    }

    @Override
    public void animationTick(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, @NotNull Random rand) {
        boolean isTop;
        int data = world.getBlockMetadata(x, y, z) & 0xF;
        boolean bl = isTop = world.getBlockMaterial(x, y + 1, z) == Material.air && !world.isBlockOpaqueCube(x, y + 1, z);
        if (rand.nextInt(64) == 0 && data > 0 && data < 8) {
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "liquid.water", rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() * 1.0f + 0.5f);
        }
        if (world.dimension == Dimension.NETHER && isTop && data == 0 && rand.nextInt(4) == 0) {
            world.spawnParticle("smoke", (double)x + Math.random(), (float)y + 0.875f, (double)z + Math.random(), 0.0, 0.0, 0.0, 1);
        }
    }

    @Override
    public void checkForHarden(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, @NotNull Material encountered) {
        int data;
        if (encountered == Material.lava && (data = world.getBlockMetadata(x, y, z) & 0xF) == 0) {
            world.setBlockWithNotify(x, y, z, Blocks.COBBLE_LIMESTONE.id());
            BlockLogicFluid.fizz(world, x, y, z);
        }
    }

    @Override
    public boolean shouldTick() {
        return false;
    }

    @Override
    public void updateTickStill(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, @NotNull Random rand) {
    }

    @Override
    public byte getFlowDecayMod(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z) {
        return 1;
    }

    @Override
    public boolean canBecomeSource(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, @NotNull Random rand) {
        return world.dimension != Dimension.NETHER;
    }

    @Override
    public void onFlowIntoBlock(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, int meta) {
        int id = world.getBlockId(x, y, z);
        if (Blocks.blocksList[id] != null) {
            Blocks.blocksList[id].dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
        }
    }

    @Override
    public boolean canSpreadTo(@NotNull BlockLogicFluid logicFluid, @NotNull World world, int x, int y, int z, @NotNull Material material) {
        return material != Material.lava;
    }
}

