/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.perlin.DensityGenerator;
import net.minecraft.core.world.generate.chunk.perlin.TerrainGeneratorLerp;
import net.minecraft.core.world.generate.chunk.perlin.nether.DensityGeneratorNether;
import net.minecraft.core.world.noise.PerlinNoise;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;

public class TerrainGeneratorNether
extends TerrainGeneratorLerp {
    private final DensityGenerator densityGenerator;
    private int lastX = Integer.MIN_VALUE;
    private int lastZ = Integer.MIN_VALUE;
    private Biome lastBiome = null;
    private Biome lastBiomeNegX = null;
    private Biome lastBiomePosX = null;
    private Biome lastBiomeNegZ = null;
    private Biome lastBiomePosZ = null;
    private Object2IntMap<Biome> fluidLookup = new Object2IntArrayMap<Biome>();
    private int lastChunkX = Integer.MIN_VALUE;
    private int lastChunkZ = Integer.MIN_VALUE;
    @NotNull
    private final PerlinNoise noise = new PerlinNoise(0L, 4, 0);
    private final double @NotNull [] cache = new double[65536];

    public TerrainGeneratorNether(World world) {
        super(world);
        this.densityGenerator = new DensityGeneratorNether(world);
        this.fluidLookup.put(Biomes.NETHER_NETHER, Blocks.FLUID_LAVA_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_VOLCANIC_ISLANDS, Blocks.FLUID_LAVA_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_SULFUR_POOLS, Blocks.FLUID_WATER_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_CRYSTAL_FOREST, Blocks.FLUID_WATER_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_ASH_PLAINS, Blocks.OBSIDIAN.id());
        this.fluidLookup.put(Biomes.NETHER_BONEYARD, Blocks.COBBLE_NETHERRACK.id());
    }

    @Override
    protected int getBlockAt(Chunk chunk, int x, int y, int z, double density) {
        WorldType type;
        int quarterHeight;
        if (this.lastX != x || this.lastZ != z) {
            this.lastBiome = chunk.getBlockBiome(x, 0, z);
            this.lastBiomeNegX = x - 1 < 0 ? this.lastBiome : chunk.getBlockBiome(x - 1, 0, z);
            this.lastBiomePosX = x + 1 >= 16 ? this.lastBiome : chunk.getBlockBiome(x + 1, 0, z);
            this.lastBiomeNegZ = z - 1 < 0 ? this.lastBiome : chunk.getBlockBiome(x, 0, z - 1);
            this.lastBiomePosZ = z + 1 >= 16 ? this.lastBiome : chunk.getBlockBiome(x, 0, z + 1);
        }
        if (this.lastChunkX != chunk.xPosition || this.lastChunkZ != chunk.zPosition) {
            this.lastChunkX = chunk.xPosition;
            this.lastChunkZ = chunk.zPosition;
            this.noise.get(this.cache, chunk.xPosition * 16, 0.0, chunk.zPosition * 16, 16, 256, 16, 0.2, 0.2, 0.2);
            float avg = 0.0f;
            for (int i = 0; i < this.cache.length; ++i) {
                avg = (float)((double)avg + this.cache[i]);
            }
            avg /= (float)this.cache.length;
        }
        if (y < (quarterHeight = (type = this.world.getWorldType()).getMaxY() / 4)) {
            return 0;
        }
        if (y >= type.getMaxY() - this.rand.nextInt(5)) {
            return Blocks.BEDROCK.id();
        }
        if (y <= quarterHeight + this.rand.nextInt(5)) {
            return Blocks.BEDROCK.id();
        }
        if (density > 0.0) {
            if (this.lastBiome == Biomes.NETHER_CRYSTAL_FOREST) {
                int sizeY = 256;
                double d = this.cache[x * 16 * sizeY + z * sizeY + y];
                if (d > 0.0 && d < 2.0) {
                    return Blocks.CRYSTAL.id();
                }
                if (d > -1.0 && d < 3.0) {
                    return Blocks.COBBLE_NETHERRACK_MOSSY.id();
                }
            }
            return type.getFillerBlockId();
        }
        if (y >= quarterHeight && y < type.getOceanY()) {
            int biomeFluid = this.fluidLookup.getOrDefault((Object)this.lastBiome, 0);
            int biomeFluidNegX = this.fluidLookup.getOrDefault((Object)this.lastBiomeNegX, 0);
            int biomeFluidPosX = this.fluidLookup.getOrDefault((Object)this.lastBiomePosX, 0);
            int biomeFluidNegZ = this.fluidLookup.getOrDefault((Object)this.lastBiomeNegZ, 0);
            int biomeFluidPosZ = this.fluidLookup.getOrDefault((Object)this.lastBiomePosZ, 0);
            if (biomeFluid == biomeFluidNegX && biomeFluid == biomeFluidPosX && biomeFluid == biomeFluidNegZ && biomeFluid == biomeFluidPosZ) {
                return biomeFluid;
            }
            return Blocks.OBSIDIAN.id();
        }
        return 0;
    }

    @Override
    public DensityGenerator getDensityGenerator() {
        return this.densityGenerator;
    }
}

