/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.BlockInterface;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicSupplier;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.sound.BlockSound;
import net.minecraft.core.sound.BlockSounds;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Block<T extends BlockLogic>
implements ITaggable<Block<?>>,
IItemConvertible,
BlockInterface {
    public static boolean disableNormalEntityLogic = false;
    private final int id;
    @NotNull
    private final String key;
    @NotNull
    private final NamespaceID namespaceID;
    @NotNull
    private final BlockLogicSupplier<T> logicSupplier;
    private T logic;
    public float blockHardness;
    public float blastResistance;
    public boolean enableStats;
    public boolean isLitInteriorSurface;
    public float blockParticleGravity;
    public float friction;
    public int emission;
    public Integer lightBlock = null;
    public boolean immovable = false;
    public boolean isEntityTile = false;
    public boolean disabledNeighborMetaNotify = false;
    public boolean shouldTick = false;
    @Nullable
    public Supplier<TileEntity> entitySupplier;
    public MaterialColor overrideColor;
    private BlockSound blockSound = BlockSounds.DEFAULT;
    @NotNull
    public Supplier<Item> blockItemSupplier = () -> new ItemBlock(this);
    @Nullable Supplier<@NotNull IItemConvertible> statParent = null;

    Block(int id, @NotNull String translationKey, @NotNull String namespaceId, @NotNull BlockLogicSupplier<T> logicSupplier) {
        this.namespaceID = this.setupNamespaceId(namespaceId).makePermanent();
        this.key = this.setupTranslationKey(translationKey);
        this.id = this.setupNumericId(id);
        this.logicSupplier = Objects.requireNonNull(logicSupplier);
        this.enableStats = true;
        this.blockParticleGravity = 1.0f;
        this.friction = 0.6f;
        this.immovable = false;
    }

    private int setupNumericId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Numeric id of block '" + String.valueOf(this.namespaceID) + "' must not be negative!");
        }
        if (id >= Blocks.blocksList.length) {
            throw new IllegalArgumentException("Numeric id of block '" + String.valueOf(this.namespaceID) + "' must not be greater than '" + (Blocks.blocksList.length - 1) + "'!");
        }
        return id;
    }

    @NotNull
    private String setupTranslationKey(String translationKey) {
        if (translationKey == null) {
            throw new NullPointerException("Translation key of block '" + String.valueOf(this.namespaceID) + "' must not be null!");
        }
        if (!((String)translationKey).startsWith("tile.")) {
            translationKey = "tile." + (String)translationKey;
        }
        return translationKey;
    }

    @NotNull
    private NamespaceID setupNamespaceId(String namespaceId) {
        if (namespaceId == null) {
            throw new NullPointerException("NamespaceId must not be null!");
        }
        if (!((String)namespaceId).contains(":")) {
            namespaceId = "minecraft:" + (String)namespaceId;
        }
        try {
            return (NamespaceID)NamespaceID.fromPool((String)namespaceId).copyUnpooled();
        }
        catch (HardIllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public T getLogic() {
        return this.logic;
    }

    public Block<T> withEntity(@Nullable Supplier<TileEntity> entitySupplier) {
        this.isEntityTile = true;
        this.entitySupplier = entitySupplier;
        return this;
    }

    public Block<T> withDisabledNeighborNotifyOnMetadataChange() {
        this.disabledNeighborMetaNotify = true;
        return this;
    }

    public Block<T> withLightBlock(int blockAmount) {
        this.lightBlock = blockAmount;
        return this;
    }

    public Block<T> withLightEmission(float lightEmission) {
        this.emission = (int)(15.0f * lightEmission);
        return this;
    }

    public Block<T> withLightEmission(int lightEmission) {
        this.emission = lightEmission & 0xF;
        return this;
    }

    public Block<T> withImmovableFlagSet() {
        this.immovable = true;
        return this;
    }

    public Block<T> withBlastResistance(float blastResistance) {
        this.blastResistance = blastResistance * 3.0f;
        return this;
    }

    public Block<T> withSound(BlockSound sound) {
        this.blockSound = sound;
        return this;
    }

    public Block<T> withHardness(float blockHardness) {
        this.blockHardness = blockHardness;
        if (this.blastResistance < blockHardness * 5.0f) {
            this.blastResistance = blockHardness * 5.0f;
        }
        return this;
    }

    public Block<T> withLitInteriorSurface(boolean isLit) {
        this.isLitInteriorSurface = isLit;
        return this;
    }

    public Block<T> withSetUnbreakable() {
        this.withHardness(-1.0f);
        return this;
    }

    public Block<T> setBlockItem(@NotNull Supplier<Item> itemSupplier) {
        this.blockItemSupplier = itemSupplier;
        return this;
    }

    public Block<T> setBlockItem(@NotNull Function<Block<T>, Item> itemSupplier) {
        this.blockItemSupplier = () -> (Item)itemSupplier.apply(this);
        return this;
    }

    public Block<T> withOverrideColor(MaterialColor color) {
        this.overrideColor = color;
        return this;
    }

    public Block<T> setStatParent(@NotNull @NotNull Supplier<@NotNull IItemConvertible> icon) {
        this.statParent = icon;
        return this;
    }

    public Block<T> withDisabledStats() {
        this.enableStats = false;
        return this;
    }

    public Block<T> setTicking(boolean tick) {
        this.shouldTick = tick;
        return this;
    }

    public BlockSound getSound() {
        return this.blockSound;
    }

    public Material getMaterial() {
        return ((BlockLogic)this.logic).getMaterial();
    }

    public float getHardness() {
        return this.blockHardness;
    }

    public boolean getEnableStats() {
        return this.enableStats && this.getHardness() >= 0.0f;
    }

    @Nullable
    public Stat getStat(String statID) {
        return this.asItem().getStat(statID);
    }

    public MaterialColor getMaterialColor() {
        if (this.overrideColor != null) {
            return this.overrideColor;
        }
        return ((BlockLogic)this.logic).getMaterialColor();
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public NamespaceID namespaceId() {
        return this.namespaceID;
    }

    public void init() {
        this.logic = this.logicSupplier.get(this);
    }

    @Override
    public boolean isIn(Tag<Block<?>> tag) {
        return tag.appliesTo(this);
    }

    @Override
    public Item asItem() {
        return Item.itemsList[this.id];
    }

    @Override
    @NotNull
    public ItemStack getDefaultStack() {
        return new ItemStack(this);
    }

    public static boolean getIsLitInteriorSurface(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        @Nullable Block<?> block = source.getBlock(tilePos);
        return block != null && block.isLitInteriorSurface;
    }

    @Deprecated
    public static boolean getIsLitInteriorSurface(@NotNull WorldSource source, int x, int y, int z) {
        return Block.getIsLitInteriorSurface(source, new TilePos(x, y, z));
    }

    @SafeVarargs
    public final Block<T> withTags(Tag<Block<?>> ... tags) {
        for (Tag<Block<?>> tag : tags) {
            tag.tag(this);
        }
        return this;
    }

    public boolean hasTag(Tag<Block<?>> tag) {
        return tag.appliesTo(this);
    }

    @Override
    public boolean isCubeShaped() {
        return ((BlockLogic)this.logic).isCubeShaped();
    }

    @Override
    public boolean canPlaceOnSurface() {
        return ((BlockLogic)this.logic).canPlaceOnSurface();
    }

    @Override
    public boolean canPlaceOnSurfaceOnCondition(World world, int x, int y, int z) {
        return ((BlockLogic)this.logic).canPlaceOnSurfaceOnCondition(world, x, y, z);
    }

    @Override
    public boolean renderAsNormalBlockOnCondition(WorldSource world, int x, int y, int z) {
        return ((BlockLogic)this.logic).renderAsNormalBlockOnCondition(world, x, y, z);
    }

    @Override
    public boolean canPlaceOnSurfaceOfBlock(World world, int x, int y, int z) {
        return ((BlockLogic)this.logic).canPlaceOnSurfaceOfBlock(world, x, y, z);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return ((BlockLogic)this.logic).getBreakResult(world, dropCause, x, y, z, meta, tileEntity);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return ((BlockLogic)this.logic).getBreakResult(world, dropCause, meta, tileEntity);
    }

    @Override
    public AABB getBounds() {
        return ((BlockLogic)this.logic).getBounds();
    }

    @Override
    public AABB getBoundsRaw() {
        return ((BlockLogic)this.logic).getBoundsRaw();
    }

    @Override
    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        return ((BlockLogic)this.logic).getBlockBrightness(blockAccess, x, y, z);
    }

    @Override
    public int getLightmapCoord(WorldSource blockAccess, int x, int y, int z) {
        return ((BlockLogic)this.logic).getLightmapCoord(blockAccess, x, y, z);
    }

    @Override
    public float getAmbientOcclusionStrength(WorldSource blockAccess, int x, int y, int z) {
        return ((BlockLogic)this.logic).getAmbientOcclusionStrength(blockAccess, x, y, z);
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return ((BlockLogic)this.logic).getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public BoundingVolume getBoundingVolume(World world, int x, int y, int z) {
        return ((BlockLogic)this.logic).getBoundingVolume(world, x, y, z);
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbList) {
        ((BlockLogic)this.logic).getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
    }

    @Override
    public boolean collidesWithEntity(Entity entity, World world, int x, int y, int z) {
        return ((BlockLogic)this.logic).collidesWithEntity(entity, world, x, y, z);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return ((BlockLogic)this.logic).getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public boolean isSolidRender() {
        return ((BlockLogic)this.logic).isSolidRender();
    }

    @Override
    public boolean blocksLight() {
        return ((BlockLogic)this.logic).blocksLight();
    }

    @Override
    public boolean canCollideCheck(int meta, boolean shouldCollideWithFluids) {
        return ((BlockLogic)this.logic).canCollideCheck(meta, shouldCollideWithFluids);
    }

    @Override
    public boolean isCollidable() {
        return ((BlockLogic)this.logic).isCollidable();
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand, boolean isRandomTick) {
        ((BlockLogic)this.logic).updateTick(world, x, y, z, rand, false);
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        ((BlockLogic)this.logic).animationTick(world, x, y, z, rand);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        ((BlockLogic)this.logic).onNeighborBlockChange(world, x, y, z, blockId);
    }

    @Override
    public int tickDelay() {
        return ((BlockLogic)this.logic).tickDelay();
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        if (this.isEntityTile && !disableNormalEntityLogic && this.entitySupplier != null) {
            world.setTileEntity(x, y, z, this.entitySupplier.get());
        }
        ((BlockLogic)this.logic).onBlockPlacedByWorld(world, x, y, z);
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        ((BlockLogic)this.logic).onBlockRemoved(world, x, y, z, data);
        if (this.isEntityTile && !disableNormalEntityLogic) {
            TileEntity tileEntity;
            if (!world.isClientSide && (tileEntity = world.getTileEntity(x, y, z)) != null) {
                tileEntity.dropContents(world, x, y, z);
            }
            world.removeBlockTileEntity(x, y, z);
        }
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, Side side, int meta, Player player, Item item) {
        ((BlockLogic)this.logic).onBlockDestroyedByPlayer(world, x, y, z, side, meta, player, item);
    }

    @Override
    public float blockStrength(World world, int x, int y, int z, Side side, Player player) {
        return ((BlockLogic)this.logic).blockStrength(world, x, y, z, side, player);
    }

    @Override
    public boolean getImmovable() {
        return ((BlockLogic)this.logic).getImmovable();
    }

    @Override
    public float getBlastResistance(Entity entity) {
        return ((BlockLogic)this.logic).getBlastResistance(entity);
    }

    @Override
    public HitResult collisionRayTrace(World world, int x, int y, int z, Vec3 start, Vec3 end, boolean useSelectorBoxes) {
        return ((BlockLogic)this.logic).collisionRayTrace(world, x, y, z, start, end, useSelectorBoxes);
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int x, int y, int z) {
        ((BlockLogic)this.logic).onBlockDestroyedByExplosion(world, x, y, z);
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, Side side) {
        return ((BlockLogic)this.logic).canPlaceBlockOnSide(world, x, y, z, side);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return ((BlockLogic)this.logic).canPlaceBlockAt(world, x, y, z);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        return ((BlockLogic)this.logic).onBlockRightClicked(world, x, y, z, player, side, xHit, yHit);
    }

    @Override
    public void onActivatorInteract(World world, int x, int y, int z, TileEntityActivator activator, Direction direction) {
        ((BlockLogic)this.logic).onActivatorInteract(world, x, y, z, activator, direction);
    }

    @Override
    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        ((BlockLogic)this.logic).onEntityWalking(world, x, y, z, entity);
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        ((BlockLogic)this.logic).onBlockLeftClicked(world, x, y, z, player, side, xHit, yHit);
    }

    @Override
    public void handleEntityInside(World world, int x, int y, int z, Entity entity, Vec3 entityVelocity) {
        ((BlockLogic)this.logic).handleEntityInside(world, x, y, z, entity, entityVelocity);
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        return ((BlockLogic)this.logic).getBlockBoundsFromState(world, x, y, z);
    }

    @Override
    public boolean getSignal(WorldSource worldSource, int x, int y, int z, Side side) {
        return ((BlockLogic)this.logic).getSignal(worldSource, x, y, z, side);
    }

    @Override
    public boolean isSignalSource() {
        return ((BlockLogic)this.logic).isSignalSource();
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        ((BlockLogic)this.logic).onEntityCollidedWithBlock(world, x, y, z, entity);
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        return ((BlockLogic)this.logic).getDirectSignal(world, x, y, z, side);
    }

    @Override
    public void harvestBlock(World world, Player player, int x, int y, int z, int meta, TileEntity tileEntity) {
        ((BlockLogic)this.logic).harvestBlock(world, player, x, y, z, meta, tileEntity);
    }

    @Override
    public void dropBlockWithCause(World world, EnumDropCause cause, int x, int y, int z, int meta, TileEntity tileEntity, Player player) {
        ((BlockLogic)this.logic).dropBlockWithCause(world, cause, x, y, z, meta, tileEntity, player);
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        return ((BlockLogic)this.logic).getSupport(world, x, y, z, side);
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        return ((BlockLogic)this.logic).canBlockStay(world, x, y, z);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        ((BlockLogic)this.logic).onBlockPlacedByMob(world, x, y, z, side, mob, xPlaced, yPlaced);
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        ((BlockLogic)this.logic).onBlockPlacedOnSide(world, x, y, z, side, xPlaced, yPlaced);
    }

    @Override
    public String getLanguageKey(int meta) {
        return ((BlockLogic)this.logic).getLanguageKey(meta);
    }

    @Override
    public void triggerEvent(World world, int x, int y, int z, int index, int data) {
        ((BlockLogic)this.logic).triggerEvent(world, x, y, z, index, data);
    }

    @Override
    public int getPistonPushReaction(World world, int x, int y, int z) {
        return ((BlockLogic)this.logic).getPistonPushReaction(world, x, y, z);
    }

    @Override
    public int getPlacedBlockMetadata(@Nullable Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        return ((BlockLogic)this.logic).getPlacedBlockMetadata(player, stack, world, x, y, z, side, xPlaced, yPlaced);
    }

    @Override
    public boolean isClimbable(World world, int x, int y, int z) {
        return ((BlockLogic)this.logic).isClimbable(world, x, y, z);
    }

    @Override
    public boolean isEquivalent(@NotNull World world, int thisX, int thisY, int thisZ, int otherX, int otherY, int otherZ) {
        return ((BlockLogic)this.logic).isEquivalent(world, thisX, thisY, thisZ, otherX, otherY, otherZ);
    }

    @Override
    @NotNull
    public Side getAttachedSide(@NotNull WorldSource world, int x, int y, int z) {
        return ((BlockLogic)this.logic).getAttachedSide(world, x, y, z);
    }

    public static boolean hasLogicClass(@Nullable Block<?> block, Class<?> logicClass) {
        return block != null && logicClass.isAssignableFrom(block.getLogic().getClass());
    }
}

