/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLogicFence
extends BlockLogic
implements IPaintable {
    public BlockLogicFence(Block<?> block) {
        super(block, Material.wood);
    }

    @Override
    public boolean canPlaceOnSurface() {
        return true;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, int x, int y, int z, @NotNull Side side) {
        return side.isVertical() ? PartialSupport.INSTANCE.center() : PartialSupport.INSTANCE;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return super.getCollisionBoundingBoxFromPool(world, x, y, z).expand(0.0, 0.5, 0.0);
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbList) {
        boolean connectEast = this.canConnectTo(world, x, y, z, Side.EAST);
        boolean connectWest = this.canConnectTo(world, x, y, z, Side.WEST);
        boolean connectSouth = this.canConnectTo(world, x, y, z, Side.SOUTH);
        boolean connectNorth = this.canConnectTo(world, x, y, z, Side.NORTH);
        double thickness = 0.125;
        if (connectEast) {
            this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.375, 0.0, 0.375, 1.0, 1.5, 0.625).move(x, y, z), aabbList);
        }
        if (connectWest) {
            this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0, 0.375, 0.625, 1.5, 0.625).move(x, y, z), aabbList);
        }
        if (connectSouth) {
            this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.375, 0.0, 0.375, 0.625, 1.5, 1.0).move(x, y, z), aabbList);
        }
        if (connectNorth) {
            this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.375, 0.0, 0.0, 0.625, 1.5, 0.625).move(x, y, z), aabbList);
        }
        if (!(connectEast || connectWest || connectSouth || connectNorth)) {
            this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.375, 0.0, 0.375, 0.625, 1.5, 0.625).move(x, y, z), aabbList);
        }
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        boolean connectXPos = this.canConnectTo(world, x, y, z, Side.EAST);
        boolean connectXNeg = this.canConnectTo(world, x, y, z, Side.WEST);
        boolean connectZPos = this.canConnectTo(world, x, y, z, Side.SOUTH);
        boolean connectZNeg = this.canConnectTo(world, x, y, z, Side.NORTH);
        return AABB.fromPool(connectXNeg ? 0.0f : 0.375f, 0.0, connectZNeg ? 0.0f : 0.375f, 1.0f - (connectXPos ? 0.0f : 0.375f), 1.0, 1.0f - (connectZPos ? 0.0f : 0.375f));
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    public boolean canConnectTo(@NotNull WorldSource worldSource, int x, int y, int z, @NotNull Side side) {
        Block<?> b = worldSource.getBlock(x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ());
        return Blocks.hasTag(b, BlockTags.FENCES_CONNECT) || b != null && b.getAttachedSide(worldSource, x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ()) == side.getOpposite();
    }

    @Override
    public void setColor(World world, int x, int y, int z, DyeColor color) {
        world.setBlock(x, y, z, Blocks.FENCE_PLANKS_OAK_PAINTED.id());
        Blocks.FENCE_PLANKS_OAK_PAINTED.getLogic().setColor(world, x, y, z, color);
    }
}

