/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import org.jetbrains.annotations.Nullable;

public class PacketSetMobSpawner
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    @Nullable
    public EntityDispatcher.EntityDispatcherEntry<?> dispatcherEntry;

    public PacketSetMobSpawner() {
        this.isChunkDataPacket = true;
    }

    public PacketSetMobSpawner(int x, int y, int z, @Nullable EntityDispatcher.EntityDispatcherEntry<?> dispatcherEntry) {
        this.isChunkDataPacket = true;
        this.xPosition = x;
        this.yPosition = y;
        this.zPosition = z;
        this.dispatcherEntry = dispatcherEntry;
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        this.xPosition = dis.readInt();
        this.yPosition = dis.readShort();
        this.zPosition = dis.readInt();
        int type = dis.readShort() & 0xFFFF;
        this.dispatcherEntry = type == 65535 ? null : EntityDispatcher.getInstance().entryForNumericId(type);
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.xPosition);
        dos.writeShort(this.yPosition);
        dos.writeInt(this.zPosition);
        if (this.dispatcherEntry != null) {
            dos.writeShort(this.dispatcherEntry.numericID);
        } else {
            dos.writeShort(65535);
        }
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handleSetMobSpawner(this);
    }

    @Override
    public int getEstimatedSize() {
        return 14;
    }
}

